/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.av.impl;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.gluegen.runtime.ProcAddressTable;
import com.jogamp.opengl.util.GLPixelStorageModes;
import com.jogamp.opengl.util.av.AudioSink;
import com.jogamp.opengl.util.av.AudioSinkFactory;
import com.jogamp.opengl.util.av.GLMediaPlayer;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureSequence;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.util.av.GLMediaPlayerImpl;
import jogamp.opengl.util.av.impl.FFMPEGDynamicLibraryBundleInfo;
import jogamp.opengl.util.av.impl.FFMPEGNatives;

public class FFMPEGMediaPlayer
extends GLMediaPlayerImpl {
    private static final int ENOSYS = 38;
    private static final FFMPEGNatives natives;
    private static final int avUtilMajorVersionCC;
    private static final int avFormatMajorVersionCC;
    private static final int avCodecMajorVersionCC;
    private static final int avResampleMajorVersionCC;
    private static final int swResampleMajorVersionCC;
    private static final boolean available;
    private long moviePtr = 0L;
    private String texLookupFuncName = "ffmpegTexture2D";
    private boolean usesTexLookupShader = false;
    private FFMPEGNatives.PixelFormat vPixelFmt = null;
    private int vPlanes = 0;
    private int vBitsPerPixel = 0;
    private int vBytesPerPixelPerPlane = 0;
    private int texWidth;
    private int texHeight;
    private String singleTexComp = "r";
    private final GLPixelStorageModes psm;
    private AudioSink.AudioFormat avChosenAudioFormat;
    private int audioSamplesPerFrameAndChannel = 0;
    public static final String dev_video_linux = "/dev/video";

    public static final boolean isAvailable() {
        return available;
    }

    public FFMPEGMediaPlayer() {
        if (!available) {
            throw new RuntimeException("FFMPEGMediaPlayer not available");
        }
        this.moviePtr = natives.createInstance0(this, DEBUG_NATIVE);
        if (0L == this.moviePtr) {
            throw new GLException("Couldn't create FFMPEGInstance");
        }
        this.psm = new GLPixelStorageModes();
        this.audioSink = null;
    }

    @Override
    protected final void destroyImpl(GL gL) {
        if (this.moviePtr != 0L) {
            natives.destroyInstance0(this.moviePtr);
            this.moviePtr = 0L;
        }
        this.destroyAudioSink();
    }

    private final void destroyAudioSink() {
        AudioSink audioSink = this.audioSink;
        if (null != audioSink) {
            this.audioSink = null;
            audioSink.destroy();
        }
    }

    @Override
    protected final void initStreamImpl(int n, int n2) throws IOException {
        int n3;
        String string;
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        if (DEBUG) {
            System.err.println("initStream: p1 " + this);
        }
        String string2 = IOUtil.decodeURIIfFilePath((URI)this.streamLoc);
        this.destroyAudioSink();
        this.audioSink = -2 == n2 ? AudioSinkFactory.createNull() : AudioSinkFactory.createDefault();
        AudioSink.AudioFormat audioFormat = this.audioSink.getPreferredFormat();
        if (DEBUG) {
            System.err.println("initStream: p2 preferred " + audioFormat + ", " + this);
        }
        boolean bl = null != this.cameraPath;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        String string3 = null;
        if (bl) {
            switch (Platform.OS_TYPE) {
                case ANDROID: 
                case FREEBSD: 
                case HPUX: 
                case LINUX: 
                case SUNOS: {
                    string = dev_video_linux + this.cameraPath;
                    break;
                }
                case WINDOWS: {
                    string = this.cameraPath;
                    break;
                }
                default: {
                    string = string2;
                }
            }
            if (null != this.cameraProps) {
                string3 = (String)this.cameraProps.get("size");
                n3 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "width");
                if (n3 > 0) {
                    n4 = n3;
                }
                if ((n3 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "height")) > 0) {
                    n5 = n3;
                }
                if ((n3 = FFMPEGMediaPlayer.getPropIntVal(this.cameraProps, "rate")) > 0) {
                    n6 = n3;
                }
            }
        } else {
            string = string2;
        }
        n3 = this.audioSink.getMaxSupportedChannels();
        int n7 = audioFormat.sampleRate;
        if (DEBUG) {
            System.err.println("initStream: p3 cameraPath " + this.cameraPath + ", isCameraInput " + bl);
            System.err.println("initStream: p3 stream " + this.streamLoc + " -> " + string2 + " -> " + string);
            System.err.println("initStream: p3 vid " + n + ", sizes " + string3 + ", reqVideo " + n4 + "x" + n5 + "@" + n6 + ", aid " + n2 + ", aMaxChannelCount " + n3 + ", aPrefSampleRate " + n7);
        }
        natives.setStream0(this.moviePtr, string, bl, n, string3, n4, n5, n6, n2, n3, n7);
    }

    @Override
    protected final void initGLImpl(GL gL) throws IOException, GLException {
        int n;
        int n2;
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        if (null == this.audioSink) {
            throw new GLException("AudioSink null");
        }
        if (null != gL && -2 != this.vid) {
            final GLContextImpl gLContextImpl = (GLContextImpl)gL.getContext();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ProcAddressTable procAddressTable = gLContextImpl.getGLProcAddressTable();
                    long l = procAddressTable.getAddressFor("glTexSubImage2D");
                    long l2 = procAddressTable.getAddressFor("glGetError");
                    long l3 = procAddressTable.getAddressFor("glFlush");
                    long l4 = procAddressTable.getAddressFor("glFinish");
                    natives.setGLFuncs0(FFMPEGMediaPlayer.this.moviePtr, l, l2, l3, l4);
                    return null;
                }
            });
            n2 = 3072;
        } else {
            n2 = 1024;
        }
        if (DEBUG) {
            System.err.println("initGL: p3 avChosen " + this.avChosenAudioFormat);
        }
        if (-2 == this.aid) {
            this.audioSink.destroy();
            this.audioSink = AudioSinkFactory.createNull();
            this.audioSink.init(AudioSink.DefaultFormat, 0.0f, 512, 512, n2);
        } else {
            float f = this.audioSamplesPerFrameAndChannel > 0 ? this.avChosenAudioFormat.getSamplesDuration(this.audioSamplesPerFrameAndChannel) : 32.0f;
            n = this.audioSink.init(this.avChosenAudioFormat, f, 512, 512, n2);
            if (n == 0) {
                System.err.println("AudioSink " + this.audioSink.getClass().getName() + " does not support " + this.avChosenAudioFormat + ", using Null");
                this.audioSink.destroy();
                this.audioSink = AudioSinkFactory.createNull();
                this.audioSink.init(this.avChosenAudioFormat, 0.0f, 512, 512, n2);
            }
        }
        if (DEBUG) {
            System.err.println("initGL: p4 chosen " + this.avChosenAudioFormat);
            System.err.println("initGL: p4 chosen " + this.audioSink);
        }
        if (null != gL && -2 != this.vid) {
            int n3;
            n = 6408;
            int n4 = 5121;
            switch (this.vBytesPerPixelPerPlane) {
                case 1: {
                    if (gL.isGL3ES3()) {
                        n3 = 6403;
                        n = 6403;
                        this.singleTexComp = "r";
                        break;
                    }
                    n3 = 6406;
                    n = 6406;
                    this.singleTexComp = "a";
                    break;
                }
                case 2: {
                    if (this.vPixelFmt == FFMPEGNatives.PixelFormat.YUYV422) {
                        n3 = 6408;
                        n = 6408;
                        break;
                    }
                    n3 = 33319;
                    n = 33319;
                    break;
                }
                case 3: {
                    n3 = 6407;
                    n = 6407;
                    break;
                }
                case 4: {
                    if (this.vPixelFmt == FFMPEGNatives.PixelFormat.BGRA) {
                        n3 = 32993;
                        n = 6408;
                        break;
                    }
                    n3 = 6408;
                    n = 6408;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported bytes-per-pixel / plane " + this.vBytesPerPixelPerPlane);
                }
            }
            this.setTextureFormat(n, n3);
            this.setTextureType(n4);
            if (DEBUG) {
                System.err.println("initGL: p5: video " + (Object)((Object)this.vPixelFmt) + ", planes " + this.vPlanes + ", bpp " + this.vBitsPerPixel + "/" + this.vBytesPerPixelPerPlane + ", tex " + this.texWidth + "x" + this.texHeight + ", usesTexLookupShader " + this.usesTexLookupShader);
            }
        }
    }

    @Override
    protected final TextureSequence.TextureFrame createTexImage(GL gL, int n) {
        return new TextureSequence.TextureFrame(this.createTexImageImpl(gL, n, this.texWidth, this.texHeight));
    }

    final boolean isAudioFormatSupported(int n, int n2, int n3) {
        FFMPEGNatives.SampleFormat sampleFormat = FFMPEGNatives.SampleFormat.valueOf(n);
        AudioSink.AudioFormat audioFormat = this.avAudioFormat2Local(sampleFormat, n2, n3);
        boolean bl = this.audioSink.isSupported(audioFormat);
        if (DEBUG) {
            System.err.println("AudioSink.isSupported: " + bl + ": av[fmt " + (Object)((Object)sampleFormat) + ", rate " + n2 + ", chan " + n3 + "] -> " + audioFormat);
        }
        return bl;
    }

    private final AudioSink.AudioFormat avAudioFormat2Local(FFMPEGNatives.SampleFormat sampleFormat, int n, int n2) {
        boolean bl;
        int n3;
        boolean bl2 = true;
        boolean bl3 = true;
        switch (sampleFormat) {
            case S32: {
                bl2 = false;
            }
            case S32P: {
                n3 = 32;
                bl = true;
                break;
            }
            case S16: {
                bl2 = false;
            }
            case S16P: {
                n3 = 16;
                bl = true;
                break;
            }
            case U8: {
                bl2 = false;
            }
            case U8P: {
                n3 = 8;
                bl = false;
                break;
            }
            case DBL: {
                bl2 = false;
            }
            case DBLP: {
                n3 = 64;
                bl = true;
                bl3 = false;
                break;
            }
            case FLT: {
                bl2 = false;
            }
            case FLTP: {
                n3 = 32;
                bl = true;
                bl3 = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported sampleformat: " + (Object)((Object)sampleFormat));
            }
        }
        return new AudioSink.AudioFormat(n, n3, n2, bl, bl3, bl2, true);
    }

    void setupFFAttributes(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15) {
        FFMPEGNatives.SampleFormat sampleFormat;
        this.vPixelFmt = null;
        this.vPlanes = 0;
        this.vBitsPerPixel = 0;
        this.vBytesPerPixelPerPlane = 0;
        this.usesTexLookupShader = false;
        this.texWidth = 0;
        this.texHeight = 0;
        int[] nArray = new int[]{0, 0, 0};
        if (-2 != n) {
            this.vPixelFmt = FFMPEGNatives.PixelFormat.valueOf(n2);
            this.vPlanes = n3;
            this.vBitsPerPixel = n4;
            this.vBytesPerPixelPerPlane = n5;
            nArray[0] = n6;
            nArray[1] = n7;
            nArray[2] = n8;
            switch (this.vPixelFmt) {
                case YUVJ420P: 
                case YUV420P: {
                    this.usesTexLookupShader = true;
                    this.texWidth = nArray[0] + nArray[1];
                    this.texHeight = n10;
                    break;
                }
                case YUVJ422P: 
                case YUV422P: {
                    this.usesTexLookupShader = true;
                    this.texWidth = nArray[0] + nArray[1] + nArray[2];
                    this.texHeight = n10;
                    break;
                }
                case YUYV422: 
                case BGR24: {
                    this.usesTexLookupShader = true;
                    this.texWidth = nArray[0];
                    this.texHeight = n10;
                    break;
                }
                case RGB24: 
                case ARGB: 
                case RGBA: 
                case ABGR: 
                case BGRA: {
                    this.usesTexLookupShader = false;
                    this.texWidth = nArray[0];
                    this.texHeight = n10;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported pixelformat: " + (Object)((Object)this.vPixelFmt));
                }
            }
        }
        this.avChosenAudioFormat = null;
        this.audioSamplesPerFrameAndChannel = 0;
        if (-2 != n11) {
            sampleFormat = FFMPEGNatives.SampleFormat.valueOf(n12);
            this.avChosenAudioFormat = this.avAudioFormat2Local(sampleFormat, n13, n14);
            this.audioSamplesPerFrameAndChannel = n15;
        } else {
            sampleFormat = null;
        }
        if (DEBUG) {
            System.err.println("audio: id " + n11 + ", fmt " + (Object)((Object)sampleFormat) + ", " + this.avChosenAudioFormat + ", aFrameSize/fc " + n15);
            System.err.println("video: id " + n + ", fmt " + n9 + "x" + n10 + ", " + (Object)((Object)this.vPixelFmt) + ", planes " + this.vPlanes + ", bpp " + this.vBitsPerPixel + "/" + this.vBytesPerPixelPerPlane + ", usesTexLookupShader " + this.usesTexLookupShader);
            for (int i = 0; i < 3; ++i) {
                System.err.println("video: p[" + i + "]: " + nArray[i]);
            }
            System.err.println("video: total tex " + this.texWidth + "x" + this.texHeight);
            System.err.println(this.toString());
        }
    }

    void updateVidAttributes(boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
    }

    @Override
    public final String getTextureLookupFunctionName(String string) throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        if (this.usesTexLookupShader) {
            if (null != string && string.length() > 0) {
                this.texLookupFuncName = string;
            }
            return this.texLookupFuncName;
        }
        return super.getTextureLookupFunctionName(string);
    }

    @Override
    public final String getTextureLookupFragmentShaderImpl() throws IllegalStateException {
        if (GLMediaPlayer.State.Uninitialized == this.state) {
            throw new IllegalStateException("Instance not initialized: " + this);
        }
        if (!this.usesTexLookupShader) {
            return super.getTextureLookupFragmentShaderImpl();
        }
        float f = (float)this.getWidth() / (float)this.texWidth;
        switch (this.vPixelFmt) {
            case YUVJ420P: 
            case YUV420P: {
                return "vec4 " + this.texLookupFuncName + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n" + "  vec2 u_off = vec2(" + f + ", 0.0);\n" + "  vec2 v_off = vec2(" + f + ", 0.5);\n" + "  vec2 tc_half = texCoord*0.5;\n" + "  float y,u,v,r,g,b;\n" + "  y = texture2D(image, texCoord)." + this.singleTexComp + ";\n" + "  u = texture2D(image, u_off+tc_half)." + this.singleTexComp + ";\n" + "  v = texture2D(image, v_off+tc_half)." + this.singleTexComp + ";\n" + "  y = 1.1643*(y-0.0625);\n" + "  u = u-0.5;\n" + "  v = v-0.5;\n" + "  r = y+1.5958*v;\n" + "  g = y-0.39173*u-0.81290*v;\n" + "  b = y+2.017*u;\n" + "  return vec4(r, g, b, 1);\n" + "}\n";
            }
            case YUVJ422P: 
            case YUV422P: {
                return "vec4 " + this.texLookupFuncName + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n" + "  vec2 u_off = vec2(" + f + "      , 0.0);\n" + "  vec2 v_off = vec2(" + f + " * 1.5, 0.0);\n" + "  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n" + "  float y,u,v,r,g,b;\n" + "  y = texture2D(image, texCoord)." + this.singleTexComp + ";\n" + "  u = texture2D(image, u_off+tc_halfw)." + this.singleTexComp + ";\n" + "  v = texture2D(image, v_off+tc_halfw)." + this.singleTexComp + ";\n" + "  y = 1.1643*(y-0.0625);\n" + "  u = u-0.5;\n" + "  v = v-0.5;\n" + "  r = y+1.5958*v;\n" + "  g = y-0.39173*u-0.81290*v;\n" + "  b = y+2.017*u;\n" + "  return vec4(r, g, b, 1);\n" + "}\n";
            }
            case YUYV422: {
                return "vec4 " + this.texLookupFuncName + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n" + "  " + "  float y1,u,y2,v,y,r,g,b;\n" + "  vec2 tc_halfw = vec2(texCoord.x*0.5, texCoord.y);\n" + "  vec4 yuyv = texture2D(image, tc_halfw).rgba;\n" + "  y1 = yuyv.r;\n" + "  u  = yuyv.g;\n" + "  y2 = yuyv.b;\n" + "  v  = yuyv.a;\n" + "  y = mix( y1, y2, mod(gl_FragCoord.x, 2) ); /* avoid branching! */\n" + "  y = 1.1643*(y-0.0625);\n" + "  u = u-0.5;\n" + "  v = v-0.5;\n" + "  r = y+1.5958*v;\n" + "  g = y-0.39173*u-0.81290*v;\n" + "  b = y+2.017*u;\n" + "  return vec4(r, g, b, 1);\n" + "}\n";
            }
            case BGR24: {
                return "vec4 " + this.texLookupFuncName + "(in " + this.getTextureSampler2DType() + " image, in vec2 texCoord) {\n" + "  " + "  vec3 bgr = texture2D(image, texCoord).rgb;\n" + "  return vec4(bgr.b, bgr.g, bgr.r, 1);\n" + "}\n";
            }
        }
        throw new InternalError("Add proper mapping of: vPixelFmt " + (Object)((Object)this.vPixelFmt) + ", usesTexLookupShader " + this.usesTexLookupShader);
    }

    @Override
    public final boolean playImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        int n = natives.play0(this.moviePtr);
        if (DEBUG_NATIVE && n != 0 && n != -38) {
            System.err.println("libav play err: " + n);
        }
        return true;
    }

    @Override
    public final boolean pauseImpl() {
        if (0L == this.moviePtr) {
            return false;
        }
        int n = natives.pause0(this.moviePtr);
        if (DEBUG_NATIVE && n != 0 && n != -38) {
            System.err.println("libav pause err: " + n);
        }
        return true;
    }

    @Override
    protected final synchronized int seekImpl(int n) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        return natives.seek0(this.moviePtr, n);
    }

    @Override
    protected void preNextTextureImpl(GL gL) {
        this.psm.setUnpackAlignment(gL, 1);
        gL.glActiveTexture(33984 + this.getTextureUnit());
    }

    @Override
    protected void postNextTextureImpl(GL gL) {
        this.psm.restore(gL);
    }

    @Override
    protected final int getNextTextureImpl(GL gL, TextureSequence.TextureFrame textureFrame) {
        if (0L == this.moviePtr) {
            throw new GLException("FFMPEG native instance null");
        }
        int n = Integer.MIN_VALUE;
        if (null != gL) {
            Texture texture = textureFrame.getTexture();
            texture.enable(gL);
            texture.bind(gL);
        }
        for (int i = 0; Integer.MIN_VALUE == n && 10 > i; ++i) {
            n = natives.readNextPacket0(this.moviePtr, this.textureTarget, this.textureFormat, this.textureType);
        }
        if (null != textureFrame) {
            textureFrame.setPTS(n);
        }
        return n;
    }

    final void pushSound(ByteBuffer byteBuffer, int n, int n2) {
        this.setFirstAudioPTS2SCR(n2);
        if (1.0f == this.playSpeed || this.audioSinkPlaySpeedSet) {
            this.audioSink.enqueueData(n2, byteBuffer, n);
        }
    }

    static {
        boolean bl;
        boolean bl2 = FFMPEGDynamicLibraryBundleInfo.initSingleton();
        if (FFMPEGDynamicLibraryBundleInfo.libsLoaded()) {
            natives = FFMPEGDynamicLibraryBundleInfo.getNatives();
            if (null != natives) {
                avCodecMajorVersionCC = natives.getAvCodecMajorVersionCC0();
                avFormatMajorVersionCC = natives.getAvFormatMajorVersionCC0();
                avUtilMajorVersionCC = natives.getAvUtilMajorVersionCC0();
                avResampleMajorVersionCC = natives.getAvResampleMajorVersionCC0();
                swResampleMajorVersionCC = natives.getSwResampleMajorVersionCC0();
            } else {
                avUtilMajorVersionCC = 0;
                avFormatMajorVersionCC = 0;
                avCodecMajorVersionCC = 0;
                avResampleMajorVersionCC = 0;
                swResampleMajorVersionCC = 0;
            }
            VersionNumber versionNumber = FFMPEGDynamicLibraryBundleInfo.avCodecVersion;
            VersionNumber versionNumber2 = FFMPEGDynamicLibraryBundleInfo.avFormatVersion;
            VersionNumber versionNumber3 = FFMPEGDynamicLibraryBundleInfo.avUtilVersion;
            VersionNumber versionNumber4 = FFMPEGDynamicLibraryBundleInfo.avResampleVersion;
            boolean bl3 = FFMPEGDynamicLibraryBundleInfo.avResampleLoaded();
            VersionNumber versionNumber5 = FFMPEGDynamicLibraryBundleInfo.swResampleVersion;
            boolean bl4 = FFMPEGDynamicLibraryBundleInfo.swResampleLoaded();
            System.err.println("LIB_AV Codec   : " + versionNumber + " [cc " + avCodecMajorVersionCC + "]");
            System.err.println("LIB_AV Format  : " + versionNumber2 + " [cc " + avFormatMajorVersionCC + "]");
            System.err.println("LIB_AV Util    : " + versionNumber3 + " [cc " + avUtilMajorVersionCC + "]");
            System.err.println("LIB_AV Resample: " + versionNumber4 + " [cc " + avResampleMajorVersionCC + ", loaded " + bl3 + "]");
            System.err.println("LIB_SW Resample: " + versionNumber5 + " [cc " + swResampleMajorVersionCC + ", loaded " + bl4 + "]");
            System.err.println("LIB_AV Device  : [loaded " + FFMPEGDynamicLibraryBundleInfo.avDeviceLoaded() + "]");
            System.err.println("LIB_AV Class   : " + (null != natives ? natives.getClass().getSimpleName() : "n/a"));
            boolean bl5 = bl = !(avCodecMajorVersionCC != versionNumber.getMajor() || avFormatMajorVersionCC != versionNumber2.getMajor() || avUtilMajorVersionCC != versionNumber3.getMajor() || bl3 && avResampleMajorVersionCC >= 0 && avResampleMajorVersionCC != versionNumber4.getMajor() || bl4 && swResampleMajorVersionCC >= 0 && swResampleMajorVersionCC != versionNumber5.getMajor());
            if (!bl) {
                System.err.println("LIB_AV Not Matching Compile-Time / Runtime Major-Version");
            }
        } else {
            natives = null;
            avUtilMajorVersionCC = 0;
            avFormatMajorVersionCC = 0;
            avCodecMajorVersionCC = 0;
            avResampleMajorVersionCC = 0;
            swResampleMajorVersionCC = 0;
            bl = false;
        }
        available = bl2 && bl && null != natives;
    }
}

