/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.CmapFormat;

public class CmapFormat2
extends CmapFormat {
    private int[] _subHeaderKeys = new int[256];
    private SubHeader[] _subHeaders;
    private int[] _glyphIndexArray;

    protected CmapFormat2(DataInput dataInput) throws IOException {
        super(dataInput);
        int n;
        int n2;
        this._format = 2;
        int n3 = 6;
        int n4 = 0;
        for (n2 = 0; n2 < 256; ++n2) {
            this._subHeaderKeys[n2] = dataInput.readUnsignedShort();
            n4 = Math.max(n4, this._subHeaderKeys[n2]);
            n3 += 2;
        }
        n2 = n4 / 8 + 1;
        this._subHeaders = new SubHeader[n2];
        int n5 = 8 * n2 + 518;
        n4 = 0;
        for (n = 0; n < this._subHeaders.length; ++n) {
            SubHeader subHeader = new SubHeader();
            subHeader._firstCode = dataInput.readUnsignedShort();
            subHeader._entryCount = dataInput.readUnsignedShort();
            subHeader._idDelta = dataInput.readShort();
            subHeader._idRangeOffset = dataInput.readUnsignedShort();
            subHeader._arrayIndex = ((n3 += 8) - 2 + subHeader._idRangeOffset - n5) / 2;
            n4 = Math.max(n4, subHeader._arrayIndex + subHeader._entryCount);
            this._subHeaders[n] = subHeader;
        }
        this._glyphIndexArray = new int[n4];
        for (n = 0; n < this._glyphIndexArray.length; ++n) {
            this._glyphIndexArray[n] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public int getRangeCount() {
        return this._subHeaders.length;
    }

    @Override
    public CmapFormat.Range getRange(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this._subHeaders.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = 0;
        if (n != 0) {
            for (int i = 0; i < 256; ++i) {
                if (this._subHeaderKeys[i] / 8 != n) continue;
                n2 = i << 8;
                break;
            }
        }
        return new CmapFormat.Range(this, n2 | this._subHeaders[n]._firstCode, n2 | this._subHeaders[n]._firstCode + this._subHeaders[n]._entryCount - 1);
    }

    @Override
    public int mapCharCode(int n) {
        int n2 = 0;
        int n3 = n >> 8;
        if (n3 != 0) {
            n2 = this._subHeaderKeys[n3] / 8;
        }
        SubHeader subHeader = this._subHeaders[n2];
        int n4 = n & 0xFF;
        if (n4 < subHeader._firstCode || n4 >= subHeader._firstCode + subHeader._entryCount) {
            return 0;
        }
        int n5 = this._glyphIndexArray[subHeader._arrayIndex + (n4 - subHeader._firstCode)];
        if (n5 != 0) {
            n5 += subHeader._idDelta;
            n5 %= 65536;
        }
        return n5;
    }

    private class SubHeader {
        int _firstCode;
        int _entryCount;
        short _idDelta;
        int _idRangeOffset;
        int _arrayIndex;

        private SubHeader() {
        }
    }
}

