/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import javax.media.opengl.GL;
import javax.media.opengl.GL2ES2;
import javax.media.opengl.GL2ES3;
import javax.media.opengl.GLException;

public class GLPixelStorageModes {
    private int[] savedGL2GL3Modes = new int[8];
    private int[] savedAlignment = new int[2];
    private boolean saved = false;

    public GLPixelStorageModes() {
    }

    public GLPixelStorageModes(GL gL) {
        this.save(gL);
    }

    public final void setPackAlignment(GL gL, int n) {
        this.save(gL);
        gL.glPixelStorei(3333, n);
    }

    public final void setUnpackAlignment(GL gL, int n) {
        this.save(gL);
        gL.glPixelStorei(3317, n);
    }

    public final void setAlignment(GL gL, int n, int n2) {
        this.setPackAlignment(gL, n);
        this.setUnpackAlignment(gL, n2);
    }

    public final void setPackRowLength(GL2ES3 gL2ES3, int n) {
        this.save(gL2ES3);
        gL2ES3.glPixelStorei(3330, n);
    }

    public final void setUnpackRowLength(GL2ES2 gL2ES2, int n) {
        this.save(gL2ES2);
        gL2ES2.glPixelStorei(3314, n);
    }

    public final void setRowLength(GL2ES3 gL2ES3, int n, int n2) {
        this.setPackRowLength(gL2ES3, n);
        this.setUnpackRowLength(gL2ES3, n2);
    }

    public final void save(GL gL) {
        if (this.saved) {
            return;
        }
        if (gL.isGL2GL3()) {
            if (gL.isGL2()) {
                gL.getGL2().glPushClientAttrib(1);
            } else {
                gL.glGetIntegerv(3333, this.savedAlignment, 0);
                gL.glGetIntegerv(3317, this.savedAlignment, 1);
                gL.glGetIntegerv(3330, this.savedGL2GL3Modes, 0);
                gL.glGetIntegerv(3331, this.savedGL2GL3Modes, 1);
                gL.glGetIntegerv(3332, this.savedGL2GL3Modes, 2);
                gL.glGetIntegerv(3328, this.savedGL2GL3Modes, 3);
                gL.glGetIntegerv(3314, this.savedGL2GL3Modes, 4);
                gL.glGetIntegerv(3315, this.savedGL2GL3Modes, 5);
                gL.glGetIntegerv(3316, this.savedGL2GL3Modes, 6);
                gL.glGetIntegerv(3312, this.savedGL2GL3Modes, 7);
            }
            gL.glPixelStorei(3330, 0);
            gL.glPixelStorei(3331, 0);
            gL.glPixelStorei(3332, 0);
            gL.glPixelStorei(3328, 0);
            gL.glPixelStorei(3314, 0);
            gL.glPixelStorei(3315, 0);
            gL.glPixelStorei(3316, 0);
            gL.glPixelStorei(3312, 0);
        } else {
            gL.glGetIntegerv(3333, this.savedAlignment, 0);
            gL.glGetIntegerv(3317, this.savedAlignment, 1);
        }
        this.saved = true;
    }

    public final void restore(GL gL) throws GLException {
        if (!this.saved) {
            throw new GLException("pixel storage modes not saved");
        }
        if (gL.isGL2GL3()) {
            if (gL.isGL2()) {
                gL.getGL2().glPopClientAttrib();
            } else {
                gL.glPixelStorei(3333, this.savedAlignment[0]);
                gL.glPixelStorei(3317, this.savedAlignment[1]);
                gL.glPixelStorei(3330, this.savedGL2GL3Modes[0]);
                gL.glPixelStorei(3331, this.savedGL2GL3Modes[1]);
                gL.glPixelStorei(3332, this.savedGL2GL3Modes[2]);
                gL.glPixelStorei(3328, this.savedGL2GL3Modes[3]);
                gL.glPixelStorei(3314, this.savedGL2GL3Modes[4]);
                gL.glPixelStorei(3315, this.savedGL2GL3Modes[5]);
                gL.glPixelStorei(3316, this.savedGL2GL3Modes[6]);
                gL.glPixelStorei(3312, this.savedGL2GL3Modes[7]);
            }
        } else {
            gL.glPixelStorei(3333, this.savedAlignment[0]);
            gL.glPixelStorei(3317, this.savedAlignment[1]);
        }
        this.saved = false;
    }
}

