/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcurand;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcurand.curandDiscreteDistribution;
import jcuda.jcurand.curandGenerator;
import jcuda.jcurand.curandStatus;
import jcuda.runtime.cudaStream_t;

public class JCurand {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCurand.initialize();
    }

    private JCurand() {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary("JCurand");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCurand.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(curandStatus.stringFor(result));
        }
        return result;
    }

    public static int curandCreateGenerator(curandGenerator generator, int rng_type) {
        return JCurand.checkResult(JCurand.curandCreateGeneratorNative(generator, rng_type));
    }

    private static native int curandCreateGeneratorNative(curandGenerator var0, int var1);

    public static int curandCreateGeneratorHost(curandGenerator generator, int rng_type) {
        return JCurand.checkResult(JCurand.curandCreateGeneratorHostNative(generator, rng_type));
    }

    private static native int curandCreateGeneratorHostNative(curandGenerator var0, int var1);

    public static int curandDestroyGenerator(curandGenerator generator) {
        return JCurand.checkResult(JCurand.curandDestroyGeneratorNative(generator));
    }

    private static native int curandDestroyGeneratorNative(curandGenerator var0);

    public static int curandGetVersion(int[] version) {
        return JCurand.checkResult(JCurand.curandGetVersionNative(version));
    }

    private static native int curandGetVersionNative(int[] var0);

    public static int curandSetStream(curandGenerator generator, cudaStream_t stream) {
        return JCurand.checkResult(JCurand.curandSetStreamNative(generator, stream));
    }

    private static native int curandSetStreamNative(curandGenerator var0, cudaStream_t var1);

    public static int curandSetPseudoRandomGeneratorSeed(curandGenerator generator, long seed) {
        return JCurand.checkResult(JCurand.curandSetPseudoRandomGeneratorSeedNative(generator, seed));
    }

    private static native int curandSetPseudoRandomGeneratorSeedNative(curandGenerator var0, long var1);

    public static int curandSetGeneratorOffset(curandGenerator generator, long offset) {
        return JCurand.checkResult(JCurand.curandSetGeneratorOffsetNative(generator, offset));
    }

    private static native int curandSetGeneratorOffsetNative(curandGenerator var0, long var1);

    public static int curandSetGeneratorOrdering(curandGenerator generator, int order) {
        return JCurand.checkResult(JCurand.curandSetGeneratorOrderingNative(generator, order));
    }

    private static native int curandSetGeneratorOrderingNative(curandGenerator var0, int var1);

    public static int curandSetQuasiRandomGeneratorDimensions(curandGenerator generator, int num_dimensions) {
        return JCurand.checkResult(JCurand.curandSetQuasiRandomGeneratorDimensionsNative(generator, num_dimensions));
    }

    private static native int curandSetQuasiRandomGeneratorDimensionsNative(curandGenerator var0, int var1);

    public static int curandGenerate(curandGenerator generator, Pointer outputPtr, long num) {
        return JCurand.checkResult(JCurand.curandGenerateNative(generator, outputPtr, num));
    }

    private static native int curandGenerateNative(curandGenerator var0, Pointer var1, long var2);

    public static int curandGenerateLongLong(curandGenerator generator, Pointer outputPtr, long num) {
        return JCurand.checkResult(JCurand.curandGenerateLongLongNative(generator, outputPtr, num));
    }

    private static native int curandGenerateLongLongNative(curandGenerator var0, Pointer var1, long var2);

    public static int curandGenerateUniform(curandGenerator generator, Pointer outputPtr, long num) {
        return JCurand.checkResult(JCurand.curandGenerateUniformNative(generator, outputPtr, num));
    }

    private static native int curandGenerateUniformNative(curandGenerator var0, Pointer var1, long var2);

    public static int curandGenerateUniformDouble(curandGenerator generator, Pointer outputPtr, long num) {
        return JCurand.checkResult(JCurand.curandGenerateUniformDoubleNative(generator, outputPtr, num));
    }

    private static native int curandGenerateUniformDoubleNative(curandGenerator var0, Pointer var1, long var2);

    public static int curandGenerateNormal(curandGenerator generator, Pointer outputPtr, long n, float mean, float stddev) {
        return JCurand.checkResult(JCurand.curandGenerateNormalNative(generator, outputPtr, n, mean, stddev));
    }

    private static native int curandGenerateNormalNative(curandGenerator var0, Pointer var1, long var2, float var4, float var5);

    public static int curandGenerateNormalDouble(curandGenerator generator, Pointer outputPtr, long n, double mean, double stddev) {
        return JCurand.checkResult(JCurand.curandGenerateNormalDoubleNative(generator, outputPtr, n, mean, stddev));
    }

    private static native int curandGenerateNormalDoubleNative(curandGenerator var0, Pointer var1, long var2, double var4, double var6);

    public static int curandGenerateLogNormal(curandGenerator generator, Pointer outputPtr, long n, float mean, float stddev) {
        return JCurand.checkResult(JCurand.curandGenerateLogNormalNative(generator, outputPtr, n, mean, stddev));
    }

    private static native int curandGenerateLogNormalNative(curandGenerator var0, Pointer var1, long var2, float var4, float var5);

    public static int curandGenerateLogNormalDouble(curandGenerator generator, Pointer outputPtr, long n, double mean, double stddev) {
        return JCurand.checkResult(JCurand.curandGenerateLogNormalDoubleNative(generator, outputPtr, n, mean, stddev));
    }

    private static native int curandGenerateLogNormalDoubleNative(curandGenerator var0, Pointer var1, long var2, double var4, double var6);

    public static int curandCreatePoissonDistribution(double lambda, curandDiscreteDistribution discrete_distribution) {
        return JCurand.checkResult(JCurand.curandCreatePoissonDistributionNative(lambda, discrete_distribution));
    }

    private static native int curandCreatePoissonDistributionNative(double var0, curandDiscreteDistribution var2);

    public static int curandDestroyDistribution(curandDiscreteDistribution discrete_distribution) {
        return JCurand.checkResult(JCurand.curandDestroyDistributionNative(discrete_distribution));
    }

    private static native int curandDestroyDistributionNative(curandDiscreteDistribution var0);

    public static int curandGeneratePoisson(curandGenerator generator, Pointer outputPtr, long n, double lambda) {
        return JCurand.checkResult(JCurand.curandGeneratePoissonNative(generator, outputPtr, n, lambda));
    }

    private static native int curandGeneratePoissonNative(curandGenerator var0, Pointer var1, long var2, double var4);

    public static int curandGenerateSeeds(curandGenerator generator) {
        return JCurand.checkResult(JCurand.curandGenerateSeedsNative(generator));
    }

    private static native int curandGenerateSeedsNative(curandGenerator var0);

    public static int curandGetDirectionVectors32(int[][][] vectors, int set) {
        return JCurand.checkResult(JCurand.curandGetDirectionVectors32Native(vectors, set));
    }

    private static native int curandGetDirectionVectors32Native(int[][][] var0, int var1);

    public static int curandGetScrambleConstants32(int[][] constants) {
        return JCurand.checkResult(JCurand.curandGetScrambleConstants32Native(constants));
    }

    private static native int curandGetScrambleConstants32Native(int[][] var0);

    public static int curandGetDirectionVectors64(long[][][] vectors, int set) {
        return JCurand.checkResult(JCurand.curandGetDirectionVectors64Native(vectors, set));
    }

    private static native int curandGetDirectionVectors64Native(long[][][] var0, int var1);

    public static int curandGetScrambleConstants64(long[][] constants) {
        return JCurand.checkResult(JCurand.curandGetScrambleConstants64Native(constants));
    }

    private static native int curandGetScrambleConstants64Native(long[][] var0);
}

