/*
 * Decompiled with CFR 0.152.
 */
package chess.service.algebraic.parser;

import chess.service.algebraic.parser.BoardSquare;
import chess.service.algebraic.parser.ChessBoard;
import chess.service.algebraic.parser.ChessRules;
import java.util.HashMap;
import java.util.Map;

public class MyParser {
    private static Map<Character, Integer> letter;
    private ChessRules rules;
    private ChessBoard board;
    private String fen;

    public MyParser(String fen) {
        this.fen = fen;
        letter = new HashMap<Character, Integer>();
        letter.put(Character.valueOf('a'), 1);
        letter.put(Character.valueOf('b'), 2);
        letter.put(Character.valueOf('c'), 3);
        letter.put(Character.valueOf('d'), 4);
        letter.put(Character.valueOf('e'), 5);
        letter.put(Character.valueOf('f'), 6);
        letter.put(Character.valueOf('g'), 7);
        letter.put(Character.valueOf('h'), 8);
        this.rules = new ChessRules();
        this.board = new ChessBoard();
        this.board.loadFEN(this.fen);
    }

    public String convertLANToSAN(String lan) {
        return this.UCItoPGN(lan, this.board);
    }

    private String UCItoPGN(String ucimove, ChessBoard board) {
        char fromX = ucimove.charAt(0);
        int fromY = Integer.parseInt("" + ucimove.charAt(1));
        char toX = ucimove.charAt(2);
        int toY = Integer.parseInt("" + ucimove.charAt(3));
        String piece = board.squares.get((Object)Character.valueOf((char)fromX))[fromY].piece.name;
        boolean capture = false;
        if (board.squares.get((Object)Character.valueOf((char)toX))[toY].piece != null) {
            capture = true;
        }
        if (piece.equals("king") && Math.abs(letter.get(Character.valueOf(fromX)) - letter.get(Character.valueOf(toX))) == 2) {
            if (toX == 'g') {
                return "O-O";
            }
            return "O-O-O";
        }
        String pgnfromX = "";
        String pgnfromY = "";
        if (this.evalRules((String)piece, (ChessBoard)board, (char)'\u0000', (int)-1, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "";
            pgnfromY = "";
        } else if (this.evalRules((String)piece, (ChessBoard)board, (char)fromX, (int)-1, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "" + fromX;
            pgnfromY = "";
        } else if (this.evalRules((String)piece, (ChessBoard)board, (char)'\u0000', (int)fromY, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "";
            pgnfromY = "" + fromY;
        } else if (this.evalRules((String)piece, (ChessBoard)board, (char)fromX, (int)fromY, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "" + fromX;
            pgnfromY = "" + fromY;
        }
        String pgnpiece = "";
        pgnpiece = piece.equals("knight") ? "N" : (piece.equals("pawn") ? "" : "" + Character.toUpperCase(piece.charAt(0)));
        if (("" + toX + toY).equals(board.enPassant) && piece.equals("pawn")) {
            capture = true;
        }
        String pgncapture = "";
        if (capture) {
            pgncapture = "x";
        }
        if (capture && piece.equals("pawn")) {
            pgnfromX = "" + fromX;
        }
        return pgnpiece + pgnfromX + pgnfromY + pgncapture + toX + toY;
    }

    private BoardSquare evalRules(String piece, ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        if (piece.equals("pawn")) {
            return this.rules.pawn(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("knight")) {
            return this.rules.knight(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("bishop")) {
            return this.rules.bishop(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("rook")) {
            return this.rules.rook(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("queen")) {
            return this.rules.queen(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("king")) {
            return this.rules.king(board, fromX, fromY, toX, toY, capture);
        }
        throw new IllegalArgumentException("evalRules: method not found!");
    }

    public static void main(String[] args) {
        String fen = "rnbqkbnr/pppp1ppp/4p3/8/4P3/8/PPPP1PPP/RNBQKBNR w KQkq - 0 2";
        String lan = "b1c3";
        MyParser parser = new MyParser(fen);
        String san = parser.convertLANToSAN(lan);
        System.out.println(san);
    }
}

