/*
 * Decompiled with CFR 0.152.
 */
package chess.service.algebraic.parser;

import chess.service.algebraic.parser.BoardPiece;
import chess.service.algebraic.parser.BoardSquare;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChessBoard {
    final int[] numbers = new int[]{0, 8, 7, 6, 5, 4, 3, 2, 1};
    final char[] letters = new char[]{'0', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};
    Map<Character, Integer> letter;
    String currentMove;
    String castling;
    String enPassant;
    int halfMoves;
    int fullMoves;
    List<BoardPiece> pieces = new LinkedList<BoardPiece>();
    Map<Character, BoardSquare[]> squares;

    public ChessBoard() {
        this.letter = new HashMap<Character, Integer>();
        this.letter.put(Character.valueOf('a'), 1);
        this.letter.put(Character.valueOf('b'), 2);
        this.letter.put(Character.valueOf('c'), 3);
        this.letter.put(Character.valueOf('d'), 4);
        this.letter.put(Character.valueOf('e'), 5);
        this.letter.put(Character.valueOf('f'), 6);
        this.letter.put(Character.valueOf('g'), 7);
        this.letter.put(Character.valueOf('h'), 8);
        this.squares = new HashMap<Character, BoardSquare[]>();
        this.squares.put(Character.valueOf('a'), new BoardSquare[9]);
        this.squares.put(Character.valueOf('b'), new BoardSquare[9]);
        this.squares.put(Character.valueOf('c'), new BoardSquare[9]);
        this.squares.put(Character.valueOf('d'), new BoardSquare[9]);
        this.squares.put(Character.valueOf('e'), new BoardSquare[9]);
        this.squares.put(Character.valueOf('f'), new BoardSquare[9]);
        this.squares.put(Character.valueOf('g'), new BoardSquare[9]);
        this.squares.put(Character.valueOf('h'), new BoardSquare[9]);
        for (char keyVar : this.squares.keySet()) {
            for (int j = 1; j <= 8; ++j) {
                this.squares.get((Object)Character.valueOf((char)keyVar))[j] = new BoardSquare(keyVar, j);
            }
        }
    }

    public void addPiece(String name, String color, char x, int y) {
        BoardPiece newPiece = new BoardPiece(name, color);
        newPiece.square = this.squares.get(Character.valueOf(x))[y];
        this.pieces.add(newPiece);
        this.squares.get((Object)Character.valueOf((char)x))[y].piece = newPiece;
    }

    public List<Integer> getPiece(String name, String color, char x, int y) {
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (int i = 0; i < this.pieces.size(); ++i) {
            if (this.pieces.get((int)i).name != name || this.pieces.get((int)i).color != color || this.pieces.get((int)i).square == null || (x == '\u0000' || this.pieces.get((int)i).square.x != x) && x != '\u0000' || (y == -1 || this.pieces.get((int)i).square.y != y) && y != -1) continue;
            result.add(i);
        }
        return result;
    }

    public void switchMove() {
        this.currentMove = this.currentMove.equals("white") ? "black" : "white";
    }

    public void makeMove(char fromX, int fromY, char toX, int toY, boolean capture) {
        BoardPiece previousPiece = this.squares.get((Object)Character.valueOf((char)fromX))[fromY].piece;
        previousPiece.square = this.squares.get(Character.valueOf(toX))[toY];
        if (capture && this.squares.get((Object)Character.valueOf((char)toX))[toY].piece != null) {
            this.squares.get((Object)Character.valueOf((char)toX))[toY].piece.square = null;
        }
        this.squares.get((Object)Character.valueOf((char)toX))[toY].piece = previousPiece;
        this.squares.get((Object)Character.valueOf((char)fromX))[fromY].piece = null;
    }

    public String currentFEN(boolean reduced) {
        String FEN = "";
        for (int num = 8; num >= 1; --num) {
            int emptyCounter = 0;
            for (char keyVar : this.squares.keySet()) {
                if (this.squares.get((Object)Character.valueOf((char)keyVar))[num].piece != null) {
                    if (emptyCounter != 0) {
                        FEN = FEN + emptyCounter;
                        emptyCounter = 0;
                    }
                    String pieceName = this.squares.get((Object)Character.valueOf((char)keyVar))[num].piece.name;
                    String pieceColor = this.squares.get((Object)Character.valueOf((char)keyVar))[num].piece.color;
                    int name = 0;
                    if (pieceName.equals("rook")) {
                        name = 114;
                    } else if (pieceName.equals("bishop")) {
                        name = 98;
                    } else if (pieceName.equals("queen")) {
                        name = 113;
                    } else if (pieceName.equals("king")) {
                        name = 107;
                    } else if (pieceName.equals("pawn")) {
                        name = 112;
                    } else if (pieceName.equals("knight")) {
                        name = 110;
                    }
                    if (pieceColor.equals("white")) {
                        name = Character.toUpperCase((char)name);
                        FEN = FEN + (char)name;
                        continue;
                    }
                    if (name == 0) continue;
                    FEN = FEN + (char)name;
                    continue;
                }
                ++emptyCounter;
            }
            if (emptyCounter != 0) {
                FEN = FEN + emptyCounter;
            }
            if (num == 1) continue;
            FEN = FEN + "/";
        }
        FEN = FEN + " " + this.currentMove.substring(0, 1);
        FEN = FEN + " " + this.castling;
        FEN = FEN + " " + this.enPassant;
        if (!reduced) {
            FEN = FEN + " " + this.halfMoves;
            FEN = FEN + " " + this.fullMoves;
        }
        return FEN;
    }

    public void loadFEN(String FEN) {
        for (char keyVar : this.squares.keySet()) {
            for (int j = 1; j <= 8; ++j) {
                this.squares.get((Object)Character.valueOf((char)keyVar))[j].piece = null;
            }
        }
        this.pieces = new LinkedList<BoardPiece>();
        String[] FENArray = FEN.split(" ");
        String[] boardArray = FENArray[0].split("/");
        for (int lines = 1; lines <= 8; ++lines) {
            String line = boardArray[lines - 1];
            int colsY = 1;
            for (int cols = 1; cols <= line.length(); ++cols) {
                String name;
                String color;
                char letter = line.charAt(cols - 1);
                if (("" + letter).matches("[rbqkpn]")) {
                    color = "black";
                } else if (("" + letter).matches("[RBQKPN]")) {
                    color = "white";
                } else {
                    colsY += Integer.parseInt("" + letter);
                    continue;
                }
                switch (Character.toLowerCase(letter)) {
                    case 'r': {
                        name = "rook";
                        break;
                    }
                    case 'b': {
                        name = "bishop";
                        break;
                    }
                    case 'q': {
                        name = "queen";
                        break;
                    }
                    case 'k': {
                        name = "king";
                        break;
                    }
                    case 'p': {
                        name = "pawn";
                        break;
                    }
                    case 'n': {
                        name = "knight";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("loadFEN: No piece corresponding.");
                    }
                }
                char x = this.letters[colsY];
                int y = this.numbers[lines];
                this.addPiece(name, color, x, y);
                ++colsY;
            }
        }
        this.currentMove = FENArray[1].equals("b") ? "black" : "white";
        this.castling = FENArray[2];
        this.enPassant = FENArray[3];
        this.halfMoves = Integer.parseInt(FENArray[4]);
        this.fullMoves = Integer.parseInt(FENArray[5]);
    }

    public void castle(String castling) {
        int line = this.currentMove.equals("white") ? 1 : 8;
        if (castling.matches("^O-O\\+?$")) {
            this.makeMove('e', line, 'g', line, false);
            this.makeMove('h', line, 'f', line, false);
        } else {
            this.makeMove('e', line, 'c', line, false);
            this.makeMove('a', line, 'd', line, false);
        }
        String castlestrip = "[kq]";
        if (this.currentMove.equals("white")) {
            castlestrip = "[KQ]";
        }
        this.enPassant = "-";
        ++this.halfMoves;
        if (this.currentMove.equals("black")) {
            ++this.fullMoves;
        }
        this.castling = this.castling.replaceAll(castlestrip, "");
        if (this.castling.equals("")) {
            this.castling = "-";
        }
        this.switchMove();
    }

    public void moveHandler(String piece, char fromX, int fromY, char toX, int toY, boolean capture, boolean promotion, String promoteTo) {
        this.makeMove(fromX, fromY, toX, toY, capture);
        if (piece.equals("pawn")) {
            int mod = this.currentMove.equals("white") ? 1 : -1;
            if (capture && this.enPassant.equals(toX + "" + toY)) {
                this.squares.get((Object)Character.valueOf((char)toX))[toY - mod].piece.square = null;
                this.squares.get((Object)Character.valueOf((char)toX))[toY - mod].piece = null;
            }
            this.enPassant = Math.abs(toY - fromY) == 2 && (toX != 'a' && this.squares.get((Object)Character.valueOf((char)this.letters[this.letter.get((Object)Character.valueOf((char)toX)).intValue() - 1]))[toY].piece != null && this.squares.get((Object)Character.valueOf((char)this.letters[this.letter.get((Object)Character.valueOf((char)toX)).intValue() - 1]))[toY].piece.color != this.currentMove && this.squares.get((Object)Character.valueOf((char)this.letters[this.letter.get((Object)Character.valueOf((char)toX)).intValue() - 1]))[toY].piece.name.equals("pawn") || toX != 'h' && this.squares.get((Object)Character.valueOf((char)this.letters[this.letter.get((Object)Character.valueOf((char)toX)).intValue() + 1]))[toY].piece != null && this.squares.get((Object)Character.valueOf((char)this.letters[this.letter.get((Object)Character.valueOf((char)toX)).intValue() + 1]))[toY].piece.color != this.currentMove && this.squares.get((Object)Character.valueOf((char)this.letters[this.letter.get((Object)Character.valueOf((char)toX)).intValue() + 1]))[toY].piece.name.equals("pawn")) ? "" + toX + (toY - mod) : "-";
            if (promotion) {
                this.squares.get((Object)Character.valueOf((char)toX))[toY].piece.name = promoteTo;
            }
        } else {
            this.enPassant = "-";
            if (piece.equals("rook") && this.castling.equals("-")) {
                if (fromX == 'a' && fromY == 8) {
                    this.castling = this.castling.replaceFirst("q", "");
                } else if (fromX == 'h' && fromY == 8) {
                    this.castling = this.castling.replaceFirst("k", "");
                } else if (fromX == 'a' && fromY == 1) {
                    this.castling = this.castling.replaceFirst("Q", "");
                } else if (fromX == 'h' && fromY == 1) {
                    this.castling = this.castling.replaceFirst("K", "");
                }
            }
            if (piece.equals("king") && this.castling != "-") {
                if (this.currentMove.equals("white")) {
                    this.castling = this.castling.replaceFirst("K", "");
                    this.castling = this.castling.replaceFirst("Q", "");
                } else {
                    this.castling = this.castling.replaceFirst("k", "");
                    this.castling = this.castling.replaceFirst("q", "");
                }
            }
            if (this.castling.equals("")) {
                this.castling = "-";
            }
        }
        this.halfMoves = piece.equals("pawn") || promotion || capture ? 0 : ++this.halfMoves;
        if (this.currentMove.equals("black")) {
            ++this.fullMoves;
        }
        this.switchMove();
    }
}

