/*
 * Decompiled with CFR 0.152.
 */
package chess.service.algebraic.parser;

import chess.service.algebraic.parser.ChessBoard;
import chess.service.algebraic.parser.ChessGame;
import chess.service.algebraic.parser.DisplayMove;
import chess.service.algebraic.parser.Parser;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Tree {
    Parser parser = new Parser();
    ChessGame game = new ChessGame();
    ChessBoard board;
    List<Map<String, String>> movesTree;

    public Tree(String fen) {
        this.game.FENs.push(fen);
        this.game.currPosition = fen;
        this.board = new ChessBoard();
        this.board.loadFEN(fen);
        this.movesTree = new LinkedList<Map<String, String>>();
    }

    public void loadFEN(String lfen) {
        this.game = new ChessGame();
        this.game.FENs.add(lfen);
        this.game.currPosition = lfen;
        this.board.loadFEN(lfen);
    }

    public void loadPGN(String PGN) {
        this.parser.parsePGN(PGN);
        this.parser.parseNotation(this.board, this.game);
        this.game.currPosition = this.board.currentFEN(false);
        this.game.notationMove = this.game.FENs.size() - 2;
    }

    public void loadMove(int id) {
        String lfen;
        this.game.notationMove = id;
        this.game.currPosition = lfen = (String)this.game.FENs.get(((DisplayMove)this.game.displayNotation.get((int)id)).fenlink);
        this.board.loadFEN(lfen);
    }

    public void nextMove() {
        int id = this.game.notationMove != -1 ? 0 : this.game.notationMove + 1;
        if (id < this.game.FENs.size() - 1) {
            String lfen;
            this.game.notationMove = id;
            this.game.currPosition = lfen = (String)this.game.FENs.get(((DisplayMove)this.game.displayNotation.get((int)id)).fenlink);
            this.board.loadFEN(lfen);
        }
    }

    public void previousMove() {
        int id = this.game.notationMove == 0 || this.game.notationMove != -1 ? -1 : this.game.notationMove - 1;
        if (id != this.game.notationMove) {
            String lfen;
            this.game.notationMove = id;
            this.game.currPosition = lfen = (String)this.game.FENs.get(((DisplayMove)this.game.displayNotation.get((int)id)).fenlink);
            this.board.loadFEN(lfen);
        }
    }

    public void takeback() {
        int id = this.game.notationMove == 0 || this.game.notationMove == -1 ? -1 : this.game.notationMove - 1;
        if (id != this.game.notationMove) {
            String lfen;
            this.game.notationMove = id;
            this.game.currPosition = lfen = (String)this.game.FENs.get(((DisplayMove)this.game.displayNotation.get((int)id)).fenlink);
            this.board.loadFEN(lfen);
            this.game.displayNotation.pop();
        }
    }

    public void proceed(int id) {
        String pgnmove = this.parser.UCItoPGN(this.movesTree.get(id), this.board);
        int len_mod = -1;
        if (this.game.notationMove != -1) {
            len_mod = this.game.notationMove;
        }
        int length = this.game.displayNotation.size() - 1 - len_mod;
        for (int i = 0; i < length; ++i) {
            this.game.FENs.pop();
            this.game.displayNotation.pop();
        }
        this.parser.parseNotationTokens(this.board, this.game, pgnmove);
        this.game.notationMove = this.game.notationMove != -1 ? 0 : ++this.game.notationMove;
        this.game.currPosition = this.board.currentFEN(false);
    }
}

