/*
 * Decompiled with CFR 0.152.
 */
package chess.service.algebraic.parser;

import chess.service.algebraic.parser.BoardSquare;
import chess.service.algebraic.parser.ChessBoard;
import chess.service.algebraic.parser.ChessGame;
import chess.service.algebraic.parser.ChessRules;
import chess.service.algebraic.parser.DisplayMove;
import chess.service.algebraic.parser.Tree;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private Map<Character, Integer> letter = new HashMap<Character, Integer>();
    private ChessRules rules;
    private Tree tree;

    public Parser() {
        this.letter.put(Character.valueOf('a'), 1);
        this.letter.put(Character.valueOf('b'), 2);
        this.letter.put(Character.valueOf('c'), 3);
        this.letter.put(Character.valueOf('d'), 4);
        this.letter.put(Character.valueOf('e'), 5);
        this.letter.put(Character.valueOf('f'), 6);
        this.letter.put(Character.valueOf('g'), 7);
        this.letter.put(Character.valueOf('h'), 8);
        this.rules = new ChessRules();
    }

    public String UCItoPGN(Map<String, String> moveArray, ChessBoard board) {
        if (moveArray.get("Move").equals("GE")) {
            return "GE";
        }
        String ucimove = moveArray.get("Move");
        char fromX = ucimove.charAt(0);
        char fromY = ucimove.charAt(1);
        char toX = ucimove.charAt(2);
        char toY = ucimove.charAt(3);
        String piece = board.squares.get((Object)Character.valueOf((char)fromX))[fromY].piece.name;
        boolean capture = false;
        if (board.squares.get((Object)Character.valueOf((char)toX))[toY].piece != null) {
            capture = true;
        }
        if (piece.equals("king") && Math.abs(this.letter.get(Character.valueOf(fromX)) - this.letter.get(Character.valueOf(toX))) == 2) {
            if (toX == 'g') {
                return "O-O";
            }
            return "O-O-O";
        }
        String pgnfromX = "";
        String pgnfromY = "";
        if (this.evalRules((String)piece, (ChessBoard)board, (char)'\u0000', (int)-1, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "";
            pgnfromY = "";
        } else if (this.evalRules((String)piece, (ChessBoard)board, (char)fromX, (int)-1, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "" + fromX;
            pgnfromY = "";
        } else if (this.evalRules((String)piece, (ChessBoard)board, (char)'\u0000', (int)fromY, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "";
            pgnfromY = "" + fromY;
        } else if (this.evalRules((String)piece, (ChessBoard)board, (char)fromX, (int)fromY, (char)toX, (int)toY, (boolean)capture).x != '\u0000') {
            pgnfromX = "" + fromX;
            pgnfromY = "" + fromY;
        }
        char pgnpiece = '\u0000';
        pgnpiece = piece == "knight" ? (char)'N' : (piece == "pawn" ? (char)'\u0000' : (char)Character.toUpperCase(piece.charAt(0)));
        if (("" + toX + toY).equals(board.enPassant) && piece.equals("pawn")) {
            capture = true;
        }
        char pgncapture = '\u0000';
        if (capture) {
            pgncapture = 'x';
        }
        if (capture && piece.equals("pawn")) {
            pgnfromX = "" + fromX;
        }
        return pgnpiece + pgnfromX + pgnfromY + pgncapture + toX + toY;
    }

    public void parsePGN(String PGN) {
        PGN = PGN.replaceAll("\\r\\n", "\n");
        PGN = PGN.replaceAll("\\{([\\W\\w]*?)\\}", "");
        PGN = PGN.replaceAll("\"([^ \" \\ \\r \\n]*(?:\\.[^\" \\ \\r \\n]*)*)\"", "");
        PGN = PGN.replaceFirst("(;[\\W\\w]*?)\n", "");
        ChessGame game = this.tree.game;
        String notation = PGN.replaceAll("(\\[[\\W\\w]*?\\])", "");
        notation = notation.replaceAll("\\b[\\d]+[\\s]*[\\.]+", "");
        notation = notation.replaceAll("\\([^\\(\\)]*?\\)", "");
        game.notation = notation = notation.replaceFirst("[\\s]+(?:0-1|1-0|1\\/2-1\\/2|\\*)[\\s]+", "");
        game.displayNotation.clear();
    }

    public void parseNotation(ChessBoard board, ChessGame game) {
        game.FENs.clear();
        game.FENs.add("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
        DisplayMove dispMove = new DisplayMove();
        dispMove.type = "start";
        dispMove.fenlink = 0;
        game.displayNotation.add(dispMove);
        board.loadFEN((String)game.FENs.get(0));
        this.parseNotationTokens(board, game, game.notation);
    }

    public void parseNotationTokens(ChessBoard board, ChessGame game, String notation) {
        String[] notationTokens = notation.split("[\\s]+");
        for (int i = 0; i < notationTokens.length; ++i) {
            String token = notationTokens[i];
            if (token.matches("[RBQKPN]?[a-h]?[1-8]?[x]?[a-h][1-8][=]?[QNRB]?[+#]?")) {
                this.parseMove(board, game, token);
                continue;
            }
            if (!token.matches("(O-O-O|O-O)\\+?")) continue;
            this.castle(board, game, token);
        }
    }

    public void parseMove(ChessBoard board, ChessGame game, String token) {
        Matcher matcher = Pattern.compile("([RBQKPN])?([a-h])?([1-8])?([x])?([a-h])([1-8])([=]?)([QNRB]?)([+#]?)").matcher(token);
        char[] moveArray = new char[9];
        if (matcher.find()) {
            for (int i = 0; i < 9; ++i) {
                String match = matcher.group(0);
                if (match.length() == 1) {
                    moveArray[i] = match.charAt(0);
                    continue;
                }
                if (match.length() == 0) {
                    moveArray[i] = '\u0000';
                    continue;
                }
                throw new IllegalArgumentException("parseMove: Too many matches.");
            }
        }
        String piece = "pawn";
        if (moveArray[1] != '\u0000') {
            switch (Character.toLowerCase(moveArray[1])) {
                case 'r': {
                    piece = "rook";
                    break;
                }
                case 'b': {
                    piece = "bishop";
                    break;
                }
                case 'q': {
                    piece = "queen";
                    break;
                }
                case 'n': {
                    piece = "knight";
                    break;
                }
                case 'k': {
                    piece = "king";
                    break;
                }
            }
        }
        char fromX = moveArray[2];
        int fromY = Integer.parseInt("" + moveArray[3]);
        boolean capture = moveArray[4] != '\u0000';
        char toX = moveArray[5];
        int toY = Integer.parseInt("" + moveArray[6]);
        boolean promotion = false;
        String promoteTo = "";
        if (moveArray[8] != '\u0000') {
            promotion = true;
            switch (Character.toLowerCase(moveArray[8])) {
                case 'r': {
                    promoteTo = "rook";
                    break;
                }
                case 'b': {
                    promoteTo = "bishop";
                    break;
                }
                case 'q': {
                    promoteTo = "queen";
                    break;
                }
                case 'n': {
                    promoteTo = "knight";
                    break;
                }
            }
        }
        BoardSquare pieceXY = this.evalRules(piece, board, fromX, fromY, toX, toY, capture);
        DisplayMove dispMove = new DisplayMove();
        dispMove.type = "regular";
        dispMove.token = token;
        dispMove.color = board.currentMove;
        dispMove.fromX = pieceXY.x;
        dispMove.fromY = pieceXY.y;
        dispMove.toX = toX;
        dispMove.toY = toY;
        board.moveHandler(piece, pieceXY.x, pieceXY.y, toX, toY, capture, promotion, promoteTo);
        game.FENs.add(board.currentFEN(false));
        dispMove.num = board.fullMoves;
        dispMove.fenlink = game.FENs.size() - 1;
        game.displayNotation.add(dispMove);
    }

    public void castle(ChessBoard board, ChessGame game, String token) {
        int line = board.currentMove == "white" ? 1 : 8;
        DisplayMove dispMove = new DisplayMove();
        dispMove.type = "regular";
        dispMove.token = token;
        dispMove.color = board.currentMove;
        if (token.matches("^O-O\\+?$")) {
            dispMove.fromX = (char)101;
            dispMove.fromY = line;
            dispMove.toX = (char)103;
            dispMove.toY = line;
        } else {
            dispMove.fromX = (char)101;
            dispMove.fromY = line;
            dispMove.toX = (char)99;
            dispMove.toY = line;
        }
        board.castle(token);
        game.FENs.add(board.currentFEN(false));
        dispMove.num = board.fullMoves;
        dispMove.fenlink = game.FENs.size() - 1;
        game.displayNotation.add(dispMove);
    }

    private BoardSquare evalRules(String piece, ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        if (piece.equals("pawn")) {
            return this.rules.pawn(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("knight")) {
            return this.rules.knight(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("bishop")) {
            return this.rules.bishop(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("rook")) {
            return this.rules.rook(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("queen")) {
            return this.rules.queen(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("king")) {
            return this.rules.king(board, fromX, fromY, toX, toY, capture);
        }
        throw new IllegalArgumentException("evalRules: method not found!");
    }
}

