/*
 * Decompiled with CFR 0.152.
 */
package chess.service.algebraic.parser;

import chess.service.algebraic.parser.BoardPiece;
import chess.service.algebraic.parser.BoardSquare;
import chess.service.algebraic.parser.ChessBoard;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChessRules {
    Map<Character, Integer> letter;
    char[] letters = new char[]{'0', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h'};

    public ChessRules() {
        this.letter = new HashMap<Character, Integer>();
        this.letter.put(Character.valueOf('a'), 1);
        this.letter.put(Character.valueOf('b'), 2);
        this.letter.put(Character.valueOf('c'), 3);
        this.letter.put(Character.valueOf('d'), 4);
        this.letter.put(Character.valueOf('e'), 5);
        this.letter.put(Character.valueOf('f'), 6);
        this.letter.put(Character.valueOf('g'), 7);
        this.letter.put(Character.valueOf('h'), 8);
    }

    public BoardSquare pawn(ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        LinkedList<BoardPiece> legalPawns = new LinkedList<BoardPiece>();
        BoardSquare result = null;
        int toXnum = this.letter.get(Character.valueOf(toX));
        int mod = board.currentMove.equals("white") ? 1 : -1;
        List<Integer> pawns = board.getPiece("pawn", board.currentMove, fromX, -1);
        for (int i = 0; i < pawns.size(); ++i) {
            BoardPiece pawn = board.pieces.get(pawns.get(i));
            int pawnX = this.letter.get(Character.valueOf(pawn.square.x));
            int pawnY = pawn.square.y;
            if ((capture || toY != pawnY + mod * 2 && toY != pawnY + mod || toXnum != pawnX) && (!capture || toY != pawnY + mod || toXnum != pawnX + 1 && toXnum != pawnX - 1)) continue;
            legalPawns.add(pawn);
        }
        if (legalPawns.size() > 1) {
            result = new BoardSquare(toX, toY - mod);
        } else if (legalPawns.size() == 1) {
            result = new BoardSquare(((BoardPiece)legalPawns.get((int)0)).square.x, ((BoardPiece)legalPawns.get((int)0)).square.y);
        }
        return result;
    }

    public BoardSquare knight(ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        LinkedList<BoardPiece> legalKnights = new LinkedList<BoardPiece>();
        int toXnum = this.letter.get(Character.valueOf(toX));
        List<Integer> knights = board.getPiece("knight", board.currentMove, fromX, fromY);
        for (int i = 0; i < knights.size(); ++i) {
            BoardPiece knight = board.pieces.get(knights.get(i));
            int knightX = this.letter.get(Character.valueOf(knight.square.x));
            int knightY = knight.square.y;
            if ((Math.abs(toY - knightY) != 1 || Math.abs(toXnum - knightX) != 2) && (Math.abs(toY - knightY) != 2 || Math.abs(toXnum - knightX) != 1)) continue;
            legalKnights.add(knight);
        }
        return this.executeCheck(board, legalKnights, toX, toY, capture);
    }

    public BoardSquare bishop(ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        LinkedList<BoardPiece> legalBishops = new LinkedList<BoardPiece>();
        int toXnum = this.letter.get(Character.valueOf(toX));
        List<Integer> bishops = board.getPiece("bishop", board.currentMove, fromX, fromY);
        for (int i = 0; i < bishops.size(); ++i) {
            BoardPiece bishop = board.pieces.get(bishops.get(i));
            int bishopX = this.letter.get(Character.valueOf(bishop.square.x));
            int bishopY = bishop.square.y;
            int xDiff = toXnum - bishopX;
            int yDiff = toY - bishopY;
            if (Math.abs(xDiff) != Math.abs(yDiff)) continue;
            boolean blocked = false;
            int modX = xDiff > 0 ? 1 : -1;
            int modY = xDiff == yDiff ? 1 : -1;
            for (int j = 1; j < Math.abs(xDiff); ++j) {
                if (board.squares.get((Object)Character.valueOf((char)this.letters[toXnum - modX * j]))[toY - modX * modY * j].piece == null) continue;
                blocked = true;
            }
            if (blocked) continue;
            legalBishops.add(bishop);
        }
        return this.executeCheck(board, legalBishops, toX, toY, capture);
    }

    public BoardSquare rook(ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        LinkedList<BoardPiece> legalRooks = new LinkedList<BoardPiece>();
        int toXnum = this.letter.get(Character.valueOf(toX));
        List<Integer> rooks = board.getPiece("rook", board.currentMove, fromX, fromY);
        for (int i = 0; i < rooks.size(); ++i) {
            int diff;
            boolean modY;
            BoardPiece rook = board.pieces.get(rooks.get(i));
            int rookX = this.letter.get(Character.valueOf(rook.square.x));
            int rookY = rook.square.y;
            if (toY != rookY && toXnum != rookX) continue;
            boolean blocked = false;
            if (toY == rookY) {
                modY = false;
                diff = toXnum - rookX;
            } else {
                modY = true;
                diff = toY - rookY;
            }
            int modA = diff > 0 ? 1 : -1;
            for (int j = 1; j < Math.abs(diff); ++j) {
                if (modY && board.squares.get((Object)Character.valueOf((char)this.letters[rookX]))[toY - modA * j].piece != null) {
                    blocked = true;
                    continue;
                }
                if (modY || board.squares.get((Object)Character.valueOf((char)this.letters[toXnum - modA * j]))[toY].piece == null) continue;
                blocked = true;
            }
            if (blocked) continue;
            legalRooks.add(rook);
        }
        return this.executeCheck(board, legalRooks, toX, toY, capture);
    }

    public BoardSquare queen(ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        LinkedList<BoardPiece> legalQueens = new LinkedList<BoardPiece>();
        int toXnum = this.letter.get(Character.valueOf(toX));
        List<Integer> queens = board.getPiece("queen", board.currentMove, fromX, fromY);
        for (int i = 0; i < queens.size(); ++i) {
            int diff;
            boolean modR;
            int j;
            boolean blocked;
            BoardPiece queen = board.pieces.get(queens.get(i));
            int queenX = this.letter.get(Character.valueOf(queen.square.x));
            int queenY = queen.square.y;
            int xDiff = toXnum - queenX;
            int yDiff = toY - queenY;
            if (Math.abs(xDiff) == Math.abs(yDiff)) {
                blocked = false;
                int modX = xDiff > 0 ? 1 : -1;
                int modY = xDiff == yDiff ? 1 : -1;
                for (j = 1; j < Math.abs(xDiff); ++j) {
                    if (board.squares.get((Object)Character.valueOf((char)this.letters[toXnum - modX * j]))[toY - modX * modY * j].piece == null) continue;
                    blocked = true;
                }
                if (blocked) continue;
                legalQueens.add(queen);
                continue;
            }
            if (toY != queenY && toXnum != queenX) continue;
            blocked = false;
            if (toY == queenY) {
                modR = false;
                diff = toXnum - queenX;
            } else {
                modR = true;
                diff = toY - queenY;
            }
            int modA = diff > 0 ? 1 : -1;
            for (j = 1; j < Math.abs(diff); ++j) {
                if (modR && board.squares.get((Object)Character.valueOf((char)this.letters[queenX]))[toY - modA * j].piece != null) {
                    blocked = true;
                    continue;
                }
                if (modR || board.squares.get((Object)Character.valueOf((char)this.letters[toXnum - modA * j]))[toY].piece == null) continue;
                blocked = true;
            }
            if (blocked) continue;
            legalQueens.add(queen);
        }
        return this.executeCheck(board, legalQueens, toX, toY, capture);
    }

    public BoardSquare king(ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        BoardSquare result = null;
        List<Integer> pieces = board.getPiece("king", board.currentMove, '\u0000', -1);
        if (pieces.size() == 1) {
            BoardPiece king = board.pieces.get(pieces.get(0));
            result = new BoardSquare(king.square.x, king.square.y);
            return result;
        }
        throw new IllegalArgumentException("Can't get the piece in king.");
    }

    public BoardSquare executeCheck(ChessBoard board, List<BoardPiece> legalPieces, char toX, int toY, boolean capture) {
        BoardSquare result = null;
        if (legalPieces.size() > 1) {
            for (int i = 0; i < legalPieces.size(); ++i) {
                char pieceX = legalPieces.get((int)i).square.x;
                int pieceY = legalPieces.get((int)i).square.y;
                String saveFEN = board.currentFEN(false);
                board.makeMove(pieceX, pieceY, toX, toY, capture);
                board.switchMove();
                if (!this.check(board)) {
                    result = new BoardSquare(pieceX, pieceY);
                    board.loadFEN(saveFEN);
                    break;
                }
                board.loadFEN(saveFEN);
            }
        } else if (legalPieces.size() == 1) {
            result = new BoardSquare(legalPieces.get((int)0).square.x, legalPieces.get((int)0).square.y);
        }
        return result;
    }

    public boolean check(ChessBoard board) {
        String kingColor = board.currentMove.equals("white") ? "black" : "white";
        List<Integer> pieces = board.getPiece("king", kingColor, '\u0000', -1);
        if (pieces.size() == 1) {
            BoardPiece king = board.pieces.get(pieces.get(0));
            char kingX = king.square.x;
            int kingY = king.square.y;
            for (int i = 0; i < board.pieces.size(); ++i) {
                int fromY;
                char fromX;
                BoardSquare attackArray;
                if (board.pieces.get((int)i).color != board.currentMove || (attackArray = this.eval(board.pieces.get((int)i).name, board, fromX = board.pieces.get((int)i).square.x, fromY = board.pieces.get((int)i).square.y, kingX, kingY, true)) == null) continue;
                return true;
            }
            return false;
        }
        throw new IllegalArgumentException("Can't get the piece in check.");
    }

    private BoardSquare eval(String piece, ChessBoard board, char fromX, int fromY, char toX, int toY, boolean capture) {
        if (piece.equals("pawn")) {
            return this.pawn(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("knight")) {
            return this.knight(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("bishop")) {
            return this.bishop(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("rook")) {
            return this.rook(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("queen")) {
            return this.queen(board, fromX, fromY, toX, toY, capture);
        }
        if (piece.equals("king")) {
            return this.king(board, fromX, fromY, toX, toY, capture);
        }
        throw new IllegalArgumentException("evalRules: method not found!");
    }
}

