;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via "9.3.3"
  :description "A re-frame library for WebSocket based messaging"
  :url "https://github.com/7theta/via"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[re-frame "1.2.0"]
                 [haslett "0.1.6"]

                 [com.cognitect/transit-clj "1.0.324"
                  :exclusions
                  [com.fasterxml.jackson.core/jackson-core]]
                 [com.fasterxml.jackson.core/jackson-core "2.13.0"]
                 [org.clojure/core.async "1.3.618"]

                 [metrics-clojure "2.10.0"]

                 [com.7theta/aleph "0.4.7-alpha9-3"]

                 [com.7theta/distantia "0.2.4"]
                 [com.7theta/signum "4.2.1"]
                 [com.7theta/tempus "0.3.2"]
                 [com.7theta/utilis "1.12.2"]

                 [integrant "0.8.0"]]
  :profiles {:global-vars {*warn-on-reflection* true}
             :dev {:source-paths ["dev" "example/src"]
                   :resource-paths ["example/resources"]
                   :clean-targets ^{:protect false} ["example/resources/public/js/compiled" "target"]
                   :env {:malli "true"}
                   :dependencies [[org.clojure/test.check "1.1.0"]
                                  [binaryage/devtools "1.0.3"]
                                  [thheller/shadow-cljs "2.15.5"]
                                  [integrant/repl "0.3.2"]
                                  [org.clojure/clojurescript "1.10.879"]
                                  [metosin/malli "0.6.1"]
                                  [metosin/reitit-frontend "0.5.15"]
                                  [metosin/reitit-ring "0.5.15"]]}
             :example-uberjar {:global-vars {*assert* false}
                               :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                                          "-Dclojure.spec.skip-macros=true"
                                          "-Dorg.slf4j.simpleLogger.defaultLogLevel=warn"]
                               :source-paths ["example/src" "example/main"]
                               :resource-paths ["example/resources"]
                               :dependencies [[org.clojure/clojure "1.10.3"]
                                              [org.clojure/clojurescript "1.10.879"
                                               :exclusions
                                               [com.google.javascript/closure-compiler-unshaded
                                                org.clojure/google-closure-library
                                                org.clojure/google-closure-library-third-party
                                                com.cognitect/transit-clj]]
                                              [metosin/malli "0.6.1"]
                                              [metosin/reitit-frontend "0.5.15"]
                                              [metosin/reitit-ring "0.5.15"]
                                              [integrant/repl "0.3.2"]

                                              [org.slf4j/slf4j-simple "2.0.0-alpha5"]
                                              #_[com.github.clj-easy/graal-build-time "0.1.3"]]
                               :main via.example.main
                               :aot :all
                               :uberjar-name "via.example.jar"}}
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/via"})
