# com.7theta/via
[![Current Version](https://img.shields.io/clojars/v/com.7theta/via.svg)](https://clojars.org/com.7theta/via)
[![GitHub license](https://img.shields.io/github/license/7theta/via.svg)](LICENSE)
[![Dependencies Status](https://jarkeeper.com/7theta/via/status.svg)](https://jarkeeper.com/7theta/via)

A library that provides components to manage the lifecycle of a
WebSocket connection between a
[re-frame](https://github.com/Day8/re-frame) application and a clojure server.

The `example` directory has a fully functioning application.

Check out [via-auth](https://github.com/7theta/via-auth) for
authentication strategies.

Check out [via-schema](https://github.com/7theta/via-schema) for
schema validation strategies.

## Running example application

Prior to running npm packages must be installed:
```zsh
$ npm install
```

### REPL

```clojure
user=> (dev)
dev=> (go)
```

### GraalVM native-image

Compile the example application with graalvm `native-image`:
```zsh
$ lein with-profile example-uberjar uberjar
$ native-image -jar target/via.example.jar
```
Run:
```zsh
$ ./via.example
```

## Copyright and License

Copyright © 2015-2021 7theta

Distributed under the MIT License.
