;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.util.ns
  (:require
   [clojure.string :as st]
   #?(:cljs [utilis.js :as j])))

(defn namespace?
  [ns]
  (instance? (type *ns*) ns))

(defn normalize
  [ns]
  (cond
    (nil? ns) nil
    (string? ns) (keyword
                  (-> (str ns)
                      (st/replace #"^:" "")
                      (st/replace #"/" ".")))
    (keyword? ns) (normalize (str ns))
    (namespace? ns) #?(:clj (keyword (.getName ^clojure.lang.Namespace ns))
                       :cljs (keyword (j/call ns :getName)))
    :else (throw (ex-info "Can't normalize namespace" {:ns ns}))))
