;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.core
  (:require
   [via.events :as ve]
   [via.service :as s]
   [via.subs :as vs]))

(defn subscribe
  ([query]
   (subscribe query nil))
  ([query opts]
   (subscribe (s/only-proxy (s/only-service)) query opts))
  ([proxy query opts]
   (vs/subscribe proxy query opts)))

(defn dispatch
  ([event]
   (dispatch (s/only-proxy (s/only-service)) event))
  ([proxy event]
   (ve/dispatch proxy event)))

(defn invoke
  ([event]
   (invoke (s/only-proxy (s/only-service)) event))
  ([proxy event]
   (invoke proxy event nil))
  ([proxy event opts]
   (ve/invoke proxy event opts)))
