;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.events
  (:require [via.service :as vs]
            [via.proxy :as vp]
            [via.schema :as schema]
            [signum.fx :as sfx]))

(defn dispatch
  [proxy event]
  (schema/validate-some proxy event)
  (vp/send proxy {:type :event :body event}))

(sfx/reg-fx
 :via/dispatch
 (fn [{:keys [proxy]} event]
   (dispatch proxy event)))

(defn invoke
  ([proxy event]
   (invoke proxy event nil))
  ([proxy event {:keys [_timeout] :as opts}]
   (vp/invoke proxy {:type :event :body event} opts)))
