;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via "14.0.0"
  :description "A library for WebSocket based messaging"
  :url "https://github.com/7theta/via"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[com.7theta/signum "11.0.0"]
                 [com.7theta/schema "0.3.1"
                  :exclusions [org.clojure/tools.reader]]
                 [com.7theta/distantia "0.5.4"]
                 [com.7theta/tempus "2.5.0"]
                 [com.7theta/spectator "0.7.0"]

                 [com.fasterxml.jackson.core/jackson-core "2.18.2"]
                 [com.cognitect/transit-clj "1.0.333"
                  :exclusions [com.fasterxml.jackson.core/jackson-core]]
                 [com.cognitect/transit-java "1.0.371"
                  :exclusions [com.fasterxml.jackson.core/jackson-core]]
                 [integrant "0.13.1"
                  :exclusions [org.clojure/clojure]]]
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["dev" "test"]
              :dependencies [[com.7theta/vectio "3.0.0"]
                             [com.7theta/structor "3.2.0"]]}}
  :scm {:name "git"
        :url "https://github.com/7theta/via"})
