;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via "12.9.1"
  :description "A library for WebSocket based messaging"
  :url "https://github.com/7theta/via"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[com.7theta/signum "10.0.2"]
                 [com.7theta/distantia "0.5.2"]
                 [com.7theta/tempus "2.2.0"]
                 [com.7theta/fluxus "1.0.0"]
                 [com.7theta/spectator "0.6.1"]
                 [com.7theta/schema "0.3.0"
                  :exclusions [org.clojure/tools.reader]]

                 [com.fasterxml.jackson.core/jackson-core "2.15.2"]
                 [com.cognitect/transit-clj "1.0.333"
                  :exclusions [com.fasterxml.jackson.core/jackson-core]]
                 [com.cognitect/transit-java "1.0.371"
                  :exclusions [com.fasterxml.jackson.core/jackson-core]]
                 [integrant "0.8.1"]]
  :resource-paths ^:replace []
  :jvm-opts ["--enable-preview"]
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :source-paths []
              :dependencies [[org.clojure/clojure "1.11.1"]
                             [org.clojure/test.check "1.1.1"]
                             [com.7theta/vectio "2.1.0"]]}
             :test
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["dev" "test"]
              :dependencies [[org.clojure/clojure "1.11.1"]
                             [org.clojure/test.check "1.1.1"]
                             [com.7theta/vectio "2.1.0"]]}}
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/via"})
