;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.core
  (:require [via.endpoint :as e]
            [via.events :as ve]
            [via.subs :as vs]))

(defn subscribe
  ([query]
   (subscribe query nil))
  ([query opts]
   (subscribe (e/first-connection (e/first-endpoint)) query opts))
  ([connection query {:keys [init-timeout]
                      :or {init-timeout 30000}}]
   (vs/subscribe
    (or connection (e/deferred-connection (e/first-endpoint)))
    query
    {:init-timeout init-timeout})))

(defn dispatch
  ([event]
   (dispatch (e/first-connection (e/first-endpoint)) event))
  ([connection event]
   (ve/dispatch connection event)))

(defn invoke
  ([event]
   (invoke (e/first-connection (e/first-endpoint)) event))
  ([connection event]
   (invoke connection event nil))
  ([connection event options]
   (ve/invoke connection event options)))
