;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via "12.7.5"
  :description "A library for WebSocket based messaging"
  :url "https://github.com/7theta/via"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[com.7theta/signum "9.3.4"]
                 [com.7theta/distantia "0.4.3"]
                 [com.7theta/tempus "2.1.0"]
                 [com.7theta/fluxus "0.8.0"]
                 [com.7theta/spectator "0.4.4"]

                 [com.cognitect/transit-clj "1.0.333"
                  :exclusions [com.fasterxml.jackson.core/jackson-core]]
                 [com.fasterxml.jackson.core/jackson-core "2.15.2"]
                 [metosin/malli "0.11.0"]
                 [integrant "0.8.1"]]
  :resource-paths ^:replace []
  :jvm-opts ["--enable-preview"]
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :source-paths []
              :dependencies [[org.clojure/clojure "1.11.1"]
                             [org.clojure/test.check "1.1.1"]
                             [com.7theta/vectio "1.7.2"]]}
             :test
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["dev" "test"]
              :dependencies [[org.clojure/test.check "1.1.1"]
                             [com.7theta/vectio "1.7.2"]]}}
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/via"})
