;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.events
  (:require [via.endpoint :as e]
            [via.schema :as schema]
            [fluxus.deferred :as d]))

(defn dispatch
  [connection event]
  (schema/validate-some connection event)
  (let [{:keys [endpoint]} connection
        endpoint (endpoint)]
    (e/send endpoint connection {:body event :type :event})))

(defn invoke
  ([connection event]
   (invoke connection event nil))
  ([connection event
    {:keys [timeout]
     :or {timeout 30000}}]
   (schema/validate-some connection event)
   (let [{:keys [endpoint]} connection
         endpoint (endpoint)
         reply-deferred (d/deferred)
         request-id (e/add-request-handler
                     connection
                     {:timeout timeout
                      :on-reply (partial d/success! reply-deferred)
                      :on-error #(d/error! reply-deferred
                                           (ex-info "Timed out waiting for invoke-reply"
                                                    {:event event}))})]
     (e/send endpoint connection
             {:body event
              :type :event
              :request-id request-id})
     reply-deferred)))
