;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via "12.2.1"
  :description "A library for WebSocket based messaging"
  :url "https://github.com/7theta/via"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.11.1"]
                 [com.7theta/utilis "2.3.8"]
                 [com.7theta/signum "8.5.4"]
                 [com.7theta/distantia "0.4.1"]
                 [com.7theta/tempus "0.9.3"]
                 [com.7theta/vectio "0.3.1"]
                 [com.cognitect/transit-clj "1.0.329"]
                 [metosin/malli "0.10.0"]
                 [manifold "0.3.0"]
                 [integrant "0.8.0"]]
  :resource-paths ^:replace []
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :source-paths []
              :dependencies [[org.clojure/test.check "1.1.1"]]}
             :test
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["dev" "test"]
              :dependencies [[org.clojure/test.check "1.1.1"]]}}
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/via"})
