;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.core
  (:require [via.endpoint :as e]
            [via.events :as ve]
            [via.subs :as vs]
            [signum.events :as se]
            [signum.subs :as ss]))

(defn subscribe
  ([query]
   (if (ss/sub? (first query))
     (ss/subscribe query)
     (subscribe query nil)))
  ([query opts]
   (subscribe (e/first-endpoint)
              (e/first-connection
               (e/first-endpoint))
              query
              opts))
  ([endpoint connection query {:keys [init-timeout]}]
   (vs/subscribe
    (or connection (e/deferred-connection endpoint))
    query
    {:init-timeout init-timeout})))

(defn dispatch
  ([event]
   (if (se/event? (first event))
     (se/dispatch nil event)
     (dispatch (e/first-connection (e/first-endpoint)) event)))
  ([connection event]
   (ve/dispatch connection event)))

(defn invoke
  ([event] (invoke (e/first-connection (e/first-endpoint)) event))
  ([connection event]
   (invoke connection event nil))
  ([connection event options]
   (ve/invoke connection event options)))
