;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.example.state
  (:require [signum.signal :refer [signal alter!]]
            [signum.subs :refer [reg-sub subscribe]]
            [signum.events :refer [reg-event]]
            [utilis.js :as j]))

(defonce ^:private db (signal {}))

(reg-sub
 :example/invoke-reply
 (fn [_]
   (:example/invoke-reply @db)))

(reg-event
 :example.invoke-reply/updated
 (fn [_ [_ value]]
   (alter! db assoc :example/invoke-reply value)
   nil))

(reg-sub
 :example.peers/connected
 (fn [_]
   (:example.peers/connected @db)))

(reg-sub
 :example/connection-status
 (fn [_]
   (if (not-empty @(subscribe [:example.peers/connected]))
     :connected
     :disconnected)))

(reg-event
 :example.peer/connected
 (fn [_ [_ peer-id]]
   (alter! db update :example.peers/connected #(conj (set %) peer-id))
   nil))

(reg-event
 :example.peer/disconnected
 (fn [_ [_ peer-id]]
   (alter! db update :example.peers/connected #(disj (set %) peer-id))
   nil))

(reg-sub
 :example/send-recv
 (fn [_]
   (:example/send-recv @db)))

(reg-event
 :example.peer/recv
 (fn [_ [_ value]]
   (alter! db assoc :example/send-recv value)
   nil))
