(ns via.example.subs
  (:require [via.telemetry :as telemetry]
            [signum.signal :as s]
            [signum.subs :refer [reg-sub subscribe]]
            [integrant.repl.state :refer [system]]
            [utilis.timer :as timer]
            [utilis.fn :refer [fsafe]]))

(reg-sub
 :api.example/auto-increment-counter
 (fn [query-v]
   (let [counter (s/signal 0)
         counter-timer (timer/run-every #(s/alter! counter inc) 1000)]
     {:counter counter
      :counter-timer counter-timer}))
 (fn [{:keys [counter-timer]} _]
   (timer/cancel counter-timer))
 (fn [{:keys [counter]} _]
   @counter))

(reg-sub
 :api.example.auto-increment-counter/multiply
 (fn [[_ factor]]
   (* @(subscribe [:api.example/auto-increment-counter]) factor)))

(reg-sub
 :api.example/metrics
 (fn [_]
   (let [metrics (s/signal)
         update-loop (future
                       (loop []
                         (s/alter! metrics #(try (when-let [endpoint (:via/endpoint system)]
                                                   (telemetry/metrics endpoint))
                                                 (catch Exception e
                                                   %)))
                         (Thread/sleep 1000)
                         (recur)))]
     {:metrics metrics
      :update-loop update-loop}))
 (fn [{:keys [update-loop]} _]
   (future-cancel update-loop))
 (fn [{:keys [metrics]} _]
   @metrics))

(reg-sub
 :api.example/map
 (fn [_]
   (let [value (s/signal {:key (rand-int 1000)})
         update-loop (future
                       (loop []
                         (s/alter! value (fn [_] {:key (rand-int 1000)}))
                         (Thread/sleep 1000)
                         (recur)))]
     {:value value
      :update-loop update-loop}))
 (fn [{:keys [update-loop]} _]
   (future-cancel update-loop))
 (fn [{:keys [value]} _]
   @value))
