(ns via.example.ring-handler
  (:require [via.defaults :refer [default-via-endpoint]]
            [via.example.uploader :refer [upload-handler]]
            [reitit.ring :refer [ring-handler router routes
                                 create-resource-handler
                                 create-default-handler]]
            [ring.util.response :as response]
            [ring.middleware.multipart-params.temp-file :refer [temp-file-store]]
            [reitit.ring.middleware.multipart :as multipart]
            [reitit.ring.middleware.parameters :refer [parameters-middleware]]
            [integrant.core :as ig]))

(def multipart-middleware
  (multipart/create-multipart-middleware {:store (temp-file-store)}))

(defmethod ig/init-key :via.example/ring-handler [_ {:keys [via-handler]}]
  (ring-handler
   (router
    [[default-via-endpoint via-handler]
     ["/upload" {:post {:parameters {:multipart {:file multipart/temp-file-part}}
                        :middleware [multipart-middleware parameters-middleware]
                        :handler upload-handler}}]])
   (routes
    (create-resource-handler {:path "/"})
    (create-default-handler))))

;; boilerplate for graal native-image
(defmethod response/resource-data :resource
  [^java.net.URL url]
  (let [conn (.openConnection url)]
    {:content (.getInputStream conn)
     :content-length (let [len (.getContentLength conn)] (if-not (pos? len) len))}))
