(ns via.example.events
  (:require [via.endpoint :as ve]
            [via.adapter :as va]
            [via.core :as via]
            [signum.events :as se]))

(se/reg-event
 :api.example/echo
 (fn [_ [_ value]]
   {:via/reply {:body value
                :status 200}}))

(se/reg-event
 :api.example/send-recv
 (fn [_ [_ value]]
   (let [endpoint (ve/first-endpoint)]
     (doseq [peer-id (keys @(va/peers (endpoint)))]
       (via/dispatch endpoint peer-id [:example.peer/recv value])))))

(se/reg-event
 :api.example/disconnect-self
 (fn [_ [_ value]]
   {:via/disconnect {:via/send [:example.peer/recv value]}}))
