;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via "11.6.2"
  :description "A library for WebSocket based messaging"
  :url "https://github.com/7theta/via"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.11.1"]

                 [com.7theta/signum "7.2.1"]
                 [com.7theta/distantia "0.4.0"]
                 [com.7theta/tempus "0.7.2"]
                 [com.7theta/byte-streams "0.2.8-1"]
                 [com.7theta/utilis "2.3.3"]

                 [io.netty/netty-transport "4.1.76.Final"]
                 [io.netty/netty-transport-native-epoll "4.1.76.Final"]
                 [io.netty/netty-codec "4.1.76.Final"]
                 [io.netty/netty-codec-http "4.1.76.Final"]
                 [io.netty/netty-codec-http2 "4.1.76.Final"]
                 [io.netty/netty-handler "4.1.76.Final"]
                 [io.netty/netty-handler-proxy "4.1.76.Final"]
                 [io.netty/netty-resolver "4.1.76.Final"]
                 [io.netty/netty-resolver-dns "4.1.76.Final"]

                 [com.7theta/aleph "0.4.7-alpha9-3" :exclusions [netty-transport
                                                                 netty-transport-native-epoll
                                                                 netty-codec
                                                                 netty-codec-http
                                                                 netty-codec-http2
                                                                 netty-handler
                                                                 netty-handler-proxy
                                                                 netty-resolver
                                                                 netty-resolver-dns]]

                 [haslett "0.1.7" :exclusions [org.clojure/clojure org.clojure/clojurescript
                                               org.clojure/spec.alpha org.clojure/core.specs.alpha
                                               qcom.cognitect/transit-cljs]]

                 [com.cognitect/transit-clj "1.0.329" :exclusions [com.fasterxml.jackson.core/jackson-core]]
                 [com.fasterxml.jackson.core/jackson-core "2.13.3"]
                 [com.cognitect/transit-cljs "0.8.280"]
                 [org.clojure/core.async "1.5.648"]

                 [com.brunobonacci/mulog "0.8.2"]

                 [metrics-clojure "2.10.0" :exclusions [org.slf4j/slf4j-api]]

                 [integrant "0.8.0"]]
  :profiles {:dev {:source-paths ["dev" "example/src"]
                   :resource-paths ["example/resources"]
                   :clean-targets ^{:protect false} ["example/resources/public/js/compiled" "target"]
                   :env {:malli "true"}
                   :dependencies [[com.7theta/ventus "1.3.0"]
                                  [com.7theta/structor "0.10.0"]
                                  [org.clojure/test.check "1.1.1"]
                                  [integrant/repl "0.3.2"]
                                  [metosin/malli "0.8.9"]
                                  [metosin/reitit-frontend "0.5.18"]
                                  [metosin/reitit-ring "0.5.18"]]}
             :example-uberjar {:global-vars {*assert* false}
                               :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                                          "-Dclojure.spec.skip-macros=true"
                                          "-Dorg.slf4j.simpleLogger.defaultLogLevel=warn"]
                               :source-paths ["example/src" "example/main"]
                               :resource-paths ["example/resources"]
                               :dependencies [[org.clojure/clojure "1.11.1"]
                                              [org.clojure/clojurescript "1.11.60"]
                                              [metosin/malli "0.8.8"]
                                              [metosin/reitit-ring "0.5.18"]
                                              [integrant/repl "0.3.2"]

                                              [org.slf4j/slf4j-simple "2.0.0-alpha5"]]
                               :main via.example.main
                               :aot :all
                               :uberjar-name "via.example.jar"}}
  :prep-tasks ["javac" "compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/via"})
