(ns via.util.manifold
  (:require [manifold.stream :as s]))

(defn close-and-drain!
  [feed]
  (s/close! feed)
  (let [{:keys [pending-puts]} (s/description feed)]
    (when (pos? pending-puts)
      (dotimes [_ pending-puts]
        (s/take! feed)))))
