;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.netty.http2.server.handlers.data
  (:require [via.util.netty :as n])
  (:import [io.netty.channel ChannelHandlerContext]
           [io.netty.handler.codec.http2
            Http2DataFrame
            DefaultHttp2WindowUpdateFrame]))

(defn handle?
  [msg]
  (instance? Http2DataFrame msg))

(defn handle
  [^ChannelHandlerContext ctx connection-state ^Http2DataFrame msg]
  (let [stream (.stream msg)
        stream-id (.id stream)
        pipeline (.pipeline ctx)]
    (if-let [handler (get-in @connection-state [:streams stream-id :data-frame-handler])]
      (try (handler msg)
           (finally
             (->> (-> (.initialFlowControlledBytes msg)
                      (DefaultHttp2WindowUpdateFrame.)
                      (.stream stream))
                  (n/invoke-write pipeline "frame-writer"))))
      (throw (ex-info "No handler registered for data frame"
                      {:frame msg
                       :stream stream-id}))))
  nil)
