;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.events
  (:require [via.endpoint :as via]
            [via.adapter :as adapter]
            [via.util.promise :as p]))

(declare chain-handlers)

(defn dispatch
  [endpoint peer-id event]
  (via/send endpoint peer-id event))

(defn invoke
  [endpoint peer-id event {:keys [_timeout] :as options}]
  (when (or (not endpoint) (not peer-id))
    (via/handle-event endpoint
                      :via.events/no-peer-provided
                      {:endpoint (boolean endpoint)
                       :peer-id peer-id
                       :event event}))
  (let [{:keys [timeout] :as options} (merge {:timeout (adapter/opt (endpoint) :request-timeout)}
                                             options)
        {:keys [promise] :as adapter} (p/adapter)
        chain-handlers (chain-handlers adapter options)]
    (when (and endpoint peer-id)
      (via/send endpoint peer-id event
                :on-success (chain-handlers :on-success)
                :on-failure (chain-handlers :on-failure)
                :on-timeout (chain-handlers :on-timeout)
                :timeout timeout))
    promise))


;;; Private

(defn- chain-handlers
  [adapter options]
  (fn [key]
    (if-let [f (get options key)]
      (comp f (get adapter key))
      (get adapter key))))
