;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via "11.12.2"
  :description "A library for WebSocket based messaging"
  :url "https://github.com/7theta/via"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.11.1"]
                 [com.7theta/signum "8.2.0"]
                 [com.7theta/distantia "0.4.1"]
                 [com.7theta/tempus "0.9.3"]
                 [com.7theta/utilis "2.3.6"]

                 [manifold "0.2.4"]
                 [org.clj-commons/byte-streams "0.3.1"]
                 [commons-io/commons-io "2.11.0"]

                 [io.netty/netty-transport "4.1.79.Final"]
                 [io.netty/netty-transport-native-epoll "4.1.79.Final"]
                 [io.netty/netty-codec "4.1.79.Final"]
                 [io.netty/netty-codec-http "4.1.79.Final"]
                 [io.netty/netty-codec-http2 "4.1.79.Final"]
                 [io.netty/netty-handler "4.1.79.Final"]
                 [io.netty/netty-handler-proxy "4.1.79.Final"]
                 [io.netty/netty-resolver "4.1.79.Final"]
                 [io.netty/netty-resolver-dns "4.1.79.Final"]

                 [haslett "0.1.7" :exclusions [org.clojure/clojure org.clojure/clojurescript
                                               org.clojure/spec.alpha org.clojure/core.specs.alpha
                                               qcom.cognitect/transit-cljs]]

                 [com.cognitect/transit-clj "1.0.329" :exclusions [com.fasterxml.jackson.core/jackson-core]]
                 [com.fasterxml.jackson.core/jackson-core "2.13.3"]
                 [com.cognitect/transit-cljs "0.8.280"]
                 [org.clojure/core.async "1.5.648"
                  :exclusions [org.clojure/clojure]]

                 [com.brunobonacci/mulog "0.9.0"]

                 [integrant "0.8.0"]]
  :resource-paths ^:replace []
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["dev" "example/src"]
              :resource-paths ["example/resources" "example/dev-resources"]
              :clean-targets ^{:protect false} ["target"]
              :env {:malli "true"}
              :dependencies [[com.7theta/structor "1.0.0"]
                             [com.7theta/ventus "1.5.0"]
                             [metosin/malli "0.8.9"]
                             [metosin/reitit-frontend "0.5.18"]
                             [metosin/reitit-ring "0.5.18"]
                             [metosin/reitit-middleware "0.5.18"]
                             [ring/ring-defaults "0.3.3"]
                             [aleph "0.5.0"
                              :exclusions [netty-transport
                                           netty-transport-native-epoll
                                           netty-codec
                                           netty-codec-http
                                           netty-codec-http2
                                           netty-handler
                                           netty-handler-proxy
                                           netty-resolver
                                           netty-resolver-dns]]
                             [org.clojure/test.check "1.1.1"]
                             [integrant/repl "0.3.2"]]}
             :uberjar
             {:global-vars {*assert* false}
              :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                         "-Dclojure.spec.skip-macros=true"]
              :source-paths ["example/src" "example/prod"]
              :resource-paths ["example/resources" "example/dev-resources"]
              :dependencies [[metosin/reitit-frontend "0.5.18"]
                             [metosin/reitit-ring "0.5.18"]
                             [metosin/reitit-middleware "0.5.18"]
                             [ring/ring-defaults "0.3.3"]
                             [com.github.clj-easy/graal-build-time "0.1.4"]]
              :main via.example.main
              :aot :all
              :uberjar-name "via.example.jar"}}
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/via"})
