;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns via.netty.http2.handlers.reset
  (:require [via.util.netty :as n])
  (:import [io.netty.channel ChannelHandlerContext]
           [io.netty.handler.codec.http2
            Http2ResetFrame]))

(defn handle?
  [msg]
  (instance? Http2ResetFrame msg))

(defn handle
  [^ChannelHandlerContext _ctx connection-state ^Http2ResetFrame msg]
  (let [stream (.stream msg)
        stream-id (.id stream)]
    (when-let [close (get-in @connection-state [:streams stream-id :close])]
      (close))
    nil))
