(ns via.example.downloader
  (:require [clojure.string :as st]))

(defn gen-value
  []
  (let [max-size 300000]
    (->> (range (max 1000 (rand-int max-size)))
         (map (fn [_] (rand-int 10)))
         (shuffle)
         (st/join ""))))

(def random-values (vec (repeatedly 1000 gen-value)))

(defn download-handler
  [_]
  {:status 200
   :body (rand-nth random-values)
   :headers {"content-type" "text/plain"}})
