(ns via.example.config
  (:require [via.example.events]
            [via.example.subs]
            [integrant.core :as ig]))

;;; Public

(def config
  {:via/endpoint {:exports {:namespaces #{:via.example/subs
                                          :via.example/events}}}
   :via/subs {:endpoint (ig/ref :via/endpoint)}
   ;; :via.example/broadcaster {:frequency 5
   ;;                           :via-endpoint (ig/ref :via/endpoint)}
   :via.http/server {:ring-handler (ig/ref :via.example/ring-handler)
                     :leak-detector-level :paranoid
                     :default-outbound-max-frame-size (Math/pow 2 16)
                     :tls {:server {:cert "dev-resources/certs/server.crt"
                                    :key "dev-resources/certs/server.key"}}}
   :via.example/ring-handler {:via-handler (ig/ref :via/endpoint)}})

(ig/load-namespaces config)
