(ns via.example.events
  (:require [via.endpoint :as ve]
            [via.adapter :as va]
            [via.core :as via]
            [signum.events :as se]
            [clojure.string :as st]))

(se/reg-event
 :api.example/echo
 (fn [_ [_ value]]
   {:via/reply {:body value
                :status 200}}))

(se/reg-event
 :api.example/send-recv
 (fn [_ [_ value]]
   (let [endpoint (ve/first-endpoint)]
     (doseq [peer-id (keys @(va/peers (endpoint)))]
       (via/dispatch endpoint peer-id [:example.peer/recv value])))))

(se/reg-event
 :api.example/disconnect-self
 (fn [_ [_ value]]
   {:via/disconnect {:via/send [:example.peer/recv value]}}))

(se/reg-event
 :api.example/send-large-messages
 (fn [_ _]
   (let [endpoint (ve/first-endpoint)
         peer-id (ve/first-peer endpoint)
         max-size 1000000
         gen-value (fn []
                     (->> (range (max 1000 (rand-int max-size)))
                          (map (fn [_] (rand-int 1000)))
                          (shuffle)
                          (st/join " ")))]
     (dotimes [i 10]
       (let [value (gen-value)]
         (prn :api.example/send-large-messages i (count value))
         (via/dispatch endpoint peer-id
                       [:example.peer/recv-large-message
                        {:value value}]))))))
