;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   Eclipse Public License 1.0 (http://www.eclipse.org/legal/epl-v10.html)
;;   which can be found in the LICENSE file at the root of this
;;   distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/via-auth "0.5.2"
  :description "Common authentication strategies for via"
  :url "https://github.com/7theta/via-auth"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :dependencies [[org.clojure/clojure "1.10.3"]
                 [com.7theta/via "8.3.2"]
                 [buddy/buddy-sign "3.4.1"]
                 [buddy/buddy-hashers "1.8.1"]
                 [integrant "0.8.0"]]

  :profiles {:dev {:source-paths ["dev" "example/src"]
                   :resource-paths ["example/resources"]
                   :clean-targets ^{:protect false} ["example/resources/public/js/compiled" "target"]
                   :env {:malli "true"}
                   :plugins [[lein-environ "0.4.0"]]
                   :dependencies [[binaryage/devtools "1.0.3"]
                                  [org.clojure/test.check "1.1.0"]
                                  [thheller/shadow-cljs "2.15.5"]
                                  [integrant/repl "0.3.2"]
                                  [org.clojure/clojurescript "1.10.879"]
                                  [metosin/malli "0.6.1"]]}}
  :prep-tasks ["compile"]
  :scm {:name "git"
        :url "https://github.com/7theta/via-auth"})
