;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns ventus.suspense
  (:require
   [helix.children :refer [children]]
   [helix.core :refer [<>] :as core]
   [helix.hooks :refer [use-effect use-state]]
   [ventus.core :refer [$ defnc]]))

(declare lifecycle)

(defnc suspense
  [{:keys [fallback] :as props}]
  (let [[initial-render set-initial-render] (use-state true)]
    (if initial-render
      (<>
       ($ lifecycle {:after-render #(set-initial-render false)})
       (children props))
      (core/suspense {:fallback fallback} (children props)))))

(defnc lifecycle
  [{:keys [after-render]}]
  (use-effect
   [after-render]
   (after-render)))
