;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns ventus.core
  #?@(:cljs
      [(:require-macros [ventus.core])
       (:require
        [helix.core]
        [tailwind.core]
        [ventus.hooks])]))

#?(:cljs
   (def use-signal ventus.hooks/use-signal))

#?(:cljs
   (def use-sub ventus.hooks/use-sub))

#?(:clj
   (defmacro defnc [type params & body]
     (let [opts? (map? (first body))
           opts (if opts? (first body) {})
           body (if opts? (rest body) body)
           default-opts {:helix/features {:fast-refresh true
                                          :check-invalid-hooks-usage true}
                         :wrap [`(helix.core/memo =)]}]
       `(helix.core/defnc ~type
          {:wrap [(helix.core/memo)]}
          ~params
          ~(merge default-opts opts)
          ~@body))))

#?(:clj
   (defmacro $> [component & args]
     `(helix.core/$ ~(vary-meta component assoc :native true) ~@args)))

#?(:cljs
   (def $ helix.core/$))

#?(:clj
   (defmacro <>
     [& args]
     `(helix.core/<> ~@args)))

(defmacro suspense
  [& args]
  `(helix.core/suspense ~@args))

#?(:cljs
   (defn tw
     [classes]
     (tailwind.core/tw classes)))

#?(:cljs
   (defn class->color
     [tw-color]
     (tailwind.core/class->color tw-color)))
