;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns tailwind.react-native
  (:require
   [clojure.string :as st]
   [tailwind.core]
   [twrnc :refer [create] :default twrnc-default]
   [utilis.js :as j]))

(declare tw class->color)

(def twrnc twrnc-default)

(defn init
  ([] (init nil))
  ([config]
   (when config
     (set! twrnc (create config)))
   (set! tailwind.core/tw tw)
   (set! tailwind.core/class->color class->color)))

;;; Private

(defn- tw
  ([classes] (tw classes nil))
  ([classes style]
   (let [tw-style (->> classes
                       flatten
                       (remove nil?)
                       (map #(cond-> % (keyword? %) name))
                       into-array
                       (j/call twrnc :style))]
     (if style
       (js/Object.assign #js {} tw-style (clj->js style))
       tw-style))))

(defn- class->color
  [class]
  (->> (st/split (name class) #"\-")
       (remove #{"bg" "text" "border"})
       (st/join "-")
       (j/call twrnc :color)))
