;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns figura.core
  #?(:cljs (:require-macros [figura.core]))
  (:require
   #?@(:clj [[clojure.java.io :as io]
             [clojure.xml :as xml]])
   [helix.core]
   [helix.dom]))

#?(:clj
   (defmacro deficon
     [icon-name file]
     (let [svg (xml/parse (io/file (io/resource file)))
           view-box (-> svg :attrs :viewBox)
           contents (map (fn [{:keys [tag attrs]}]
                           `(helix.core/$ ~tag ~attrs))
                         (:content svg))]
       `(helix.core/defnc ~icon-name
          [props#]
          {:helix/features {:fast-refresh true}}
          (helix.dom/svg
           {:view-box ~view-box
            :class (str (get props# :class) (get props# :className) " fill-current")
            :style (get props# :style)}
           ~@contents)))))
