;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns figura.react-native
  #?(:cljs (:require-macros [figura.react-native]))
  (:require #?@(:cljs [[clojure.core]
                       [react-native]])
            [helix.core]))

#?(:clj
   (defmacro deficon
     [icon-name filepath]
     `(let [svg-comp# (.-default (js/require ~filepath))]
        (helix.core/defnc ~icon-name
          [props#]
          {:helix/features {:fast-refresh true}
           :wrap [(helix.core/memo =)]}
          (let [style# (or (get props# :style) (clojure.core/clj->js {}))
                svg-props# (merge {}
                                  (when-let [fill# (.-color style#)]
                                    {:fill fill#
                                     :stroke fill#})
                                  (dissoc props# :style))]
            (helix.core/$ react-native/View {:style style#}
                          (helix.core/$ svg-comp# {:& svg-props#})))))))
