;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns ventus.window
  (:require [helix.hooks :refer [use-state use-effect]]
            [utilis.js :as j]))

(defn scroll-offset
  []
  (let [doc (.-documentElement js/document)]
    {:left (- (or (.-pageXOffset js/window) (.-scrollLeft doc))
              (or (.-clientLeft doc) 0))
     :top (- (or (.-pageYOffset js/window) (.-scrollTop doc))
             (or (.-clientTop doc) 0))}))

(defn focus-on-change
  [on-focus-change]
  (let [on-focus #(on-focus-change true)
        on-blur #(on-focus-change false)]
    (j/call js/window :addEventListener "focus" on-focus)
    (j/call js/window :addEventListener "blur" on-blur)
    (fn []
      (j/call js/window :removeEventListener "blur" on-blur)
      (j/call js/window :removeEventListener "focus" on-focus))))

(defn focussed?
  []
  (j/call js/document :hasFocus))

(defn use-focus
  []
  (let [[focused? set-focused] (use-state (focussed?))]
    (use-effect
     [set-focused]
     (focus-on-change set-focused))
    focused?))
