;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns ventus.modules
  #?(:clj (:require [cljs.env :as env]))
  #?@(:cljs
      [(:require-macros [ventus.modules])
       (:require [ventus.core :refer [defnc]]
                 [reitit.frontend.easy :as rf]
                 [helix.core :refer [$]]
                 [shadow.lazy :as lazy]
                 [utilis.js :as j])]))

#?(:cljs (defonce modules (atom #{})))
#?(:cljs (defonce components (atom {})))

#?(:clj
   (defmacro register-all-modules!
     []
     `(reset! modules ~(->> (:shadow.lazy/ns->mod @env/*compiler*)
                            vals
                            (map keyword)
                            distinct
                            set))))

#?(:cljs
   (defn register!
     [module component]
     (swap! components assoc module component)))

#?(:cljs
   (defn init!
     []
     (ventus.modules/register-all-modules!)))

#?(:cljs (declare load-module))

#?(:cljs
   (defnc component
     [{:keys [module props]}]
     (if-let [component (get @components module)]
       ($ component props)
       (load-module module))))

#?(:cljs
   (defn navigate
     ([module] (navigate module {}))
     ([module props]
      (rf/push-state module props))))


;;; Private

#?(:cljs
   (defn- load-module
     [module]
     (throw
      (if (and module (get @modules module))
        (-> (lazy/Loadable. [(name module)] (fn []))
            lazy/load
            (j/call :then
                    (fn []
                      (js/console.debug (str "Loaded module " (name module) ".")))
                    (fn [error]
                      (js/console.error (str "Failed to load module " (name module) ".")
                                        error))))
        (ex-info "ventus/modules unknown module" {:module module})))))
