;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns ventus.subs
  (:require [signum.subs :refer [reg-sub]]
            [signum.signal :refer [signal alter!]]
            [utilis.js :as j]))

(defonce ^:private window-size-signal
  (let [s (signal nil)
        set-size (fn [_]
                   (let [size {:width (j/get js/window :innerWidth)
                               :height (j/get js/window :innerHeight)}]
                     (alter! s (constantly size))))]
    (j/call js/window :addEventListener "resize" set-size)
    (set-size nil)
    s))

(reg-sub
 :ventus.window/size
 (fn [_]
   @window-size-signal))
