(ns ventus.subs
  (:require [signum.subs :refer [reg-sub]]
            [signum.signal :refer [signal alter!]]
            [utilis.js :as j]))

(defonce ^:private window-size-signal
  (let [s (signal nil)
        set-size (fn [_]
                   (let [size {:width (j/get js/window :innerWidth)
                               :height (j/get js/window :innerHeight)}]
                     (alter! s (constantly size))))]
    (j/call js/window :addEventListener "resize" set-size)
    (set-size nil)
    s))

(reg-sub
 :ventus.window/size
 (fn [_]
   @window-size-signal))
