;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns ventus.macros
  #?(:cljs (:require-macros [ventus.macros]))
  (:require [helix.core]
            #?(:cljs [tailwind.core])))

#?(:clj
   (defmacro $> [component & args]
     `(helix.core/$ ~(vary-meta component assoc :native true) ~@args)))

#?(:clj
   (defmacro defnc [type params & body]
     (let [opts? (map? (first body))
           opts (if opts? (first body) {})
           body (if opts? (rest body) body)
           default-opts {:helix/features {:fast-refresh true}
                         :wrap ['(helix.core/memo)]}]
       `(helix.core/defnc ~type ~params
          ~(merge default-opts opts)
          (binding [tailwind.core/*tx-classes* (#'tailwind.core/use-tailwind)]
            ~@body)))))
