;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns ventus.hooks
  (:require [signum.signal :refer [error?]]
            [helix.hooks :refer [use-state use-effect use-ref]]))

(defn use-signal
  ([signal] (use-signal signal nil ::error))
  ([signal default-val] (use-signal signal default-val ::error))
  ([signal default-val error-val]
   (let [[value set-value] (use-state default-val)
         mounted (use-ref true)]
     (use-effect
      :once
      (reset! mounted true)
      #(reset! mounted false))
     (use-effect
      [signal]
      (when signal
        (let [watch-key (str (random-uuid))]
          (add-watch signal watch-key
                     (fn [_ _ _ new-value]
                       (when @mounted
                         (set-value
                          (cond
                            (error? signal) (if (= error-val ::error)
                                              (js/console.warn
                                               (pr-str
                                                [:ventus.hooks/use-signal
                                                 {:query-v (:query-v (meta signal))
                                                  :error new-value}]))
                                              error-val)
                            (= :signum.signal/cold new-value) default-val
                            :else new-value)))))
          #(remove-watch signal watch-key))))
     value)))
