(ns ventus.macros
  #?(:cljs (:require-macros [ventus.macros]))
  (:require [helix.core]))

#?(:clj
   (defmacro $> [component & args]
     `(helix.core/$ ~(vary-meta component assoc :native true) ~@args)))

#?(:clj
   (defmacro defnc [type params & body]
     (let [opts? (map? (first body))
           opts (if opts? (first body) {})
           body (if opts? (rest body) body)
           default-opts {:helix/features {:fast-refresh true}}]
       `(helix.core/defnc ~type ~params
          ~(merge default-opts opts)
          ~@body))))
