(ns ventus.component
  (:refer-clojure :exclude [destructure])
  (:require [utilis.map :refer [map-keys compact]])
  #?(:cljs (:require-macros [ventus.component]))
  #?(:cljs (:require [utilis.map]
                     [reagent.core]
                     [ventus.util.schema])))

(defn destructure
  [component]
  (when (vector? component)
    (let [[element & args] component
          props (first args)
          props? (map? props)
          props (when props? props)
          children (if props? (rest args) args)]
      {:element element
       :props props
       :children children})))

(defn assoc-prop
  [component k v]
  (let [{:keys [element props children]} (destructure component)]
    (into [element (assoc props k v)] children)))

(defn flatten-children
  [children]
  (cond
    (not (coll? children)) nil
    (not (coll? (first children))) children
    (not children) nil

    (and (vector? (first children))
         (not (coll? (ffirst children))))
    children

    :else (recur (first children))))

#?(:cljs
   (defn validate
     [component-name schema-key-set schema value]
     (doseq [k (keys value)]
       (when (and (not (#{:key} k))
                  (not (get schema-key-set k)))
         (js/console.warn
          (goog.string/format
           "No schema provided for prop=%s, component=%s."
           (str k) component-name))))
     (ventus.util.schema/validate component-name schema value)))

#?(:clj
   (defmacro defc
     [name [{:keys [keys as defaults schema classes] :as args}] & body]
     (let [defaults (map-keys keyword defaults)
           as (or as 'props)
           schema-key-set (when (= :map (first schema))
                            (->> (rest schema)
                                 (map first)
                                 set))
           component-name (str name)]
       `(defn ~name []
          (let [this# (reagent.core/current-component)
                {:keys ~keys :as ~as} (merge ~defaults (reagent.core/props this#))
                render?# (boolean (if ventus.util.schema/VALIDATE
                                    @ventus.util.schema/loaded?
                                    true))]
            (when ventus.util.schema/VALIDATE
              (validate (str ~component-name)
                        ~schema-key-set
                        ~schema
                        (into {} ~as)))
            (when render?# ~@body))))))
