;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(def jetty-version "12.0.23")

(defproject com.7theta/vectio "3.4.0"
  :description "Flow based transport"
  :url "https://github.com/7theta/vectio"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[com.7theta/fluxus "2.2.4"]
                 [com.7theta/fides "1.6.4"]

                 [org.eclipse.jetty/jetty-server ~jetty-version]
                 [org.eclipse.jetty.http2/jetty-http2-server ~jetty-version]
                 [org.eclipse.jetty.http3/jetty-http3-server ~jetty-version]
                 [org.eclipse.jetty/jetty-alpn-server ~jetty-version]
                 [org.eclipse.jetty/jetty-alpn-java-server ~jetty-version]
                 [org.eclipse.jetty.websocket/jetty-websocket-jetty-api ~jetty-version]
                 [org.eclipse.jetty.websocket/jetty-websocket-jetty-server ~jetty-version]

                 [org.eclipse.jetty/jetty-client ~jetty-version]
                 [org.eclipse.jetty.websocket/jetty-websocket-jetty-client ~jetty-version]

                 [com.7theta/spectator "0.8.0"]
                 [integrant "0.13.1" :exclusions [org.clojure/clojure]]]
  :profiles {:repl
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["dev"]
              :resource-paths ["dev-resources"]
              :dependencies [[com.7theta/structor "3.3.0"]
                             [com.7theta/spectator-slf4j "0.1.4"]
                             [metosin/reitit-ring "0.9.1"]
                             [lilactown/helix "0.2.1"]]}
             :uberjar
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["test"]
              :dependencies [[org.clojure/clojure "1.12.1"]
                             [metosin/reitit-ring "0.9.1"]
                             [com.github.clj-easy/graal-build-time "1.0.5"]]
              :jvm-opts ["-Dclojure.compiler.direct-linking=true"
                         "-Dclojure.spec.skip-macros=true"]
              :main vectio.main
              :aot :all
              :uberjar-name "vectio.jar"}}
  :scm {:name "git"
        :url "https://github.com/7theta/vectio"})
