goog.provide('utilis.map');
/**
 * Conditionally assoc `val` into `map` at `key` if `val` passes the test
 *   specified by the optional `pred`. If `pred` is not specified, the val is
 *   tested for truthiness.
 */
utilis.map.assoc_if = (function utilis$map$assoc_if(var_args){
var G__53894 = arguments.length;
switch (G__53894) {
case 3:
return utilis.map.assoc_if.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return utilis.map.assoc_if.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(utilis.map.assoc_if.cljs$core$IFn$_invoke$arity$3 = (function (map,key,val){
return utilis.map.assoc_if.cljs$core$IFn$_invoke$arity$4(map,key,val,cljs.core.identity);
}));

(utilis.map.assoc_if.cljs$core$IFn$_invoke$arity$4 = (function (map,key,val,pred){
var G__53905 = map;
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(val) : pred.call(null, val)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__53905,key,val);
} else {
return G__53905;
}
}));

(utilis.map.assoc_if.cljs$lang$maxFixedArity = 4);

/**
 * Conditionally assoc-in `val` into `map` at `keys` if `val` passes the test
 *   specified by the optional `pred`. If `pred` is not specified, the val is
 *   tested for truthiness.
 */
utilis.map.assoc_in_if = (function utilis$map$assoc_in_if(var_args){
var G__53907 = arguments.length;
switch (G__53907) {
case 3:
return utilis.map.assoc_in_if.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return utilis.map.assoc_in_if.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(utilis.map.assoc_in_if.cljs$core$IFn$_invoke$arity$3 = (function (map,keys,val){
return utilis.map.assoc_in_if.cljs$core$IFn$_invoke$arity$4(map,keys,val,cljs.core.identity);
}));

(utilis.map.assoc_in_if.cljs$core$IFn$_invoke$arity$4 = (function (map,keys,val,pred){
var G__53908 = map;
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(val) : pred.call(null, val)))){
return cljs.core.assoc_in(G__53908,keys,val);
} else {
return G__53908;
}
}));

(utilis.map.assoc_in_if.cljs$lang$maxFixedArity = 4);

/**
 * Apply the provided function 'f' to each key in map 'm'.
 */
utilis.map.map_keys = (function utilis$map$map_keys(f,m){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (a,k,v){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(a,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(k) : f.call(null, k)),v);
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m)),cljs.core.meta(m));
});
/**
 * Apply the provided function 'f' to each value in map 'm'.
 */
utilis.map.map_vals = (function utilis$map$map_vals(f,m){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce_kv((function (a,k,v){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(a,k,(f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(v) : f.call(null, v)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),m)),cljs.core.meta(m));
});
/**
 * Return a map with the keys and values from 'm' for which 'pred'
 *   returned a truthy result for the value.
 */
utilis.map.filter_vals = (function utilis$map$filter_vals(pred,m){
return cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__53936){
var vec__53937 = p__53936;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53937,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53937,(1),null);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null, v));
}),m)),cljs.core.meta(m));
});
/**
 * Returns a map with the keys and values from 'm' with the keys and
 *   values for which 'pred' returned a truthy result removed.
 */
utilis.map.remove_vals = (function utilis$map$remove_vals(pred,m){
return utilis.map.filter_vals(cljs.core.complement(pred),m);
});
/**
 * Returns 'm' with all the keys that have nil or empty values removed.
 *   If the act of compaction results in all keys being removed a nil is
 *   returned.
 * 
 *   The compaction is recursive, e.g.,
 *  (compact {:a {:b [{} {:c {}}]}}) => nil
 */
utilis.map.compact = (function utilis$map$compact(m){
var pred = (function (v){
var or__5002__auto__ = (v == null);
if(or__5002__auto__){
return or__5002__auto__;
} else {
if(((cljs.core.seq_QMARK_(v)) || (cljs.core.coll_QMARK_(v)))){
return cljs.core.empty_QMARK_(v);
} else {
if(typeof v === 'string'){
return clojure.string.blank_QMARK_(v);
} else {
return null;
}
}
}
});
var res = (function (){var G__53952 = m;
if(((cljs.core.map_QMARK_(m)) && ((!(cljs.core.record_QMARK_(m)))))){
return cljs.core.reduce_kv((function (m__$1,k,v){
var val = ((cljs.core.map_QMARK_(v))?(utilis.map.compact.cljs$core$IFn$_invoke$arity$1 ? utilis.map.compact.cljs$core$IFn$_invoke$arity$1(v) : utilis.map.compact.call(null, v)):((cljs.core.coll_QMARK_(v))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(v),cljs.core.keep.cljs$core$IFn$_invoke$arity$2(utilis.map.compact,v)):v
));
var G__53957 = m__$1;
if(cljs.core.not(pred(val))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__53957,k,val);
} else {
return G__53957;
}
}),cljs.core.PersistentArrayMap.EMPTY,G__53952);
} else {
return G__53952;
}
})();
if(cljs.core.truth_(pred(res))){
return null;
} else {
var temp__5821__auto__ = (((!(cljs.core.var_QMARK_(m))))?cljs.core.not_empty(cljs.core.meta(m)):null);
if(cljs.core.truth_(temp__5821__auto__)){
var md = temp__5821__auto__;
return cljs.core.with_meta(res,md);
} else {
return res;
}
}
});
/**
 * Like merge-with, but merges 'maps' recursively, applying 'f'
 *   only when there is a non-map at a particular level.
 *  (deep-merge-with + {:a {:b {:c 1 :d {:x 1 :y 2}} :e 3} :f 4}
 *                     {:a {:b {:c 2 :d {:z 9} :z 3} :e 100}})
 *  => {:a {:b {:z 3, :c 3, :d {:z 9, :x 1, :y 2}}, :e 103}, :f 4}
 */
utilis.map.deep_merge_with = (function utilis$map$deep_merge_with(var_args){
var args__5732__auto__ = [];
var len__5726__auto___53997 = arguments.length;
var i__5727__auto___54004 = (0);
while(true){
if((i__5727__auto___54004 < len__5726__auto___53997)){
args__5732__auto__.push((arguments[i__5727__auto___54004]));

var G__54005 = (i__5727__auto___54004 + (1));
i__5727__auto___54004 = G__54005;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return utilis.map.deep_merge_with.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(utilis.map.deep_merge_with.cljs$core$IFn$_invoke$arity$variadic = (function (f,maps){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2((function() { 
var utilis$map$m__delegate = function (maps__$1){
if(cljs.core.every_QMARK_(cljs.core.map_QMARK_,maps__$1)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.merge_with,utilis$map$m,maps__$1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,maps__$1);
}
};
var utilis$map$m = function (var_args){
var maps__$1 = null;
if (arguments.length > 0) {
var G__54006__i = 0, G__54006__a = new Array(arguments.length -  0);
while (G__54006__i < G__54006__a.length) {G__54006__a[G__54006__i] = arguments[G__54006__i + 0]; ++G__54006__i;}
  maps__$1 = new cljs.core.IndexedSeq(G__54006__a,0,null);
} 
return utilis$map$m__delegate.call(this,maps__$1);};
utilis$map$m.cljs$lang$maxFixedArity = 0;
utilis$map$m.cljs$lang$applyTo = (function (arglist__54008){
var maps__$1 = cljs.core.seq(arglist__54008);
return utilis$map$m__delegate(maps__$1);
});
utilis$map$m.cljs$core$IFn$_invoke$arity$variadic = utilis$map$m__delegate;
return utilis$map$m;
})()
,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,maps));
}));

(utilis.map.deep_merge_with.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(utilis.map.deep_merge_with.cljs$lang$applyTo = (function (seq53959){
var G__53960 = cljs.core.first(seq53959);
var seq53959__$1 = cljs.core.next(seq53959);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53960,seq53959__$1);
}));

/**
 * Like merge, but merges 'maps' recursively.
 */
utilis.map.deep_merge = (function utilis$map$deep_merge(var_args){
var args__5732__auto__ = [];
var len__5726__auto___54009 = arguments.length;
var i__5727__auto___54010 = (0);
while(true){
if((i__5727__auto___54010 < len__5726__auto___54009)){
args__5732__auto__.push((arguments[i__5727__auto___54010]));

var G__54011 = (i__5727__auto___54010 + (1));
i__5727__auto___54010 = G__54011;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return utilis.map.deep_merge.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(utilis.map.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (maps){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(utilis.map.deep_merge_with,(function() { 
var G__54012__delegate = function (vals){
return cljs.core.last(vals);
};
var G__54012 = function (var_args){
var vals = null;
if (arguments.length > 0) {
var G__54013__i = 0, G__54013__a = new Array(arguments.length -  0);
while (G__54013__i < G__54013__a.length) {G__54013__a[G__54013__i] = arguments[G__54013__i + 0]; ++G__54013__i;}
  vals = new cljs.core.IndexedSeq(G__54013__a,0,null);
} 
return G__54012__delegate.call(this,vals);};
G__54012.cljs$lang$maxFixedArity = 0;
G__54012.cljs$lang$applyTo = (function (arglist__54014){
var vals = cljs.core.seq(arglist__54014);
return G__54012__delegate(vals);
});
G__54012.cljs$core$IFn$_invoke$arity$variadic = G__54012__delegate;
return G__54012;
})()
,maps);
}));

(utilis.map.deep_merge.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(utilis.map.deep_merge.cljs$lang$applyTo = (function (seq53971){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq53971));
}));

/**
 * Computes all nested key paths in a map.
 */
utilis.map.key_paths = (function utilis$map$key_paths(var_args){
var G__53978 = arguments.length;
switch (G__53978) {
case 1:
return utilis.map.key_paths.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return utilis.map.key_paths.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(utilis.map.key_paths.cljs$core$IFn$_invoke$arity$1 = (function (m){
return utilis.map.key_paths.cljs$core$IFn$_invoke$arity$2(m,cljs.core.PersistentVector.EMPTY);
}));

(utilis.map.key_paths.cljs$core$IFn$_invoke$arity$2 = (function (m,prefix){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic((function (p__53979){
var vec__53982 = p__53979;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53982,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53982,(1),null);
var kp = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(prefix,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [k], null));
if(cljs.core.truth_((function (){var and__5000__auto__ = cljs.core.map_QMARK_(v);
if(and__5000__auto__){
return cljs.core.not_empty(v);
} else {
return and__5000__auto__;
}
})())){
return cljs.core.cons(kp,utilis.map.key_paths.cljs$core$IFn$_invoke$arity$2(v,kp));
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [kp], null);
}
}),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m], 0));
}));

(utilis.map.key_paths.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=utilis.map.js.map
